/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterator;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.utility.ObjectTools;

public class SingleElementListIterator<E>
implements ListIterator<E> {
    private final E element;
    private boolean hasNext;

    public SingleElementListIterator(E element) {
        this.element = element;
        this.hasNext = true;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public E next() {
        if (this.hasNext) {
            this.hasNext = false;
            return this.element;
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        return this.hasNext ? 0 : 1;
    }

    @Override
    public boolean hasPrevious() {
        return !this.hasNext;
    }

    @Override
    public E previous() {
        if (this.hasNext) {
            throw new NoSuchElementException();
        }
        this.hasNext = true;
        return this.element;
    }

    @Override
    public int previousIndex() {
        return this.hasNext ? -1 : 0;
    }

    @Override
    public void add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.element);
    }
}

