/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.command;

import java.util.concurrent.ThreadFactory;
import org.eclipse.persistence.tools.utility.ExceptionHandler;
import org.eclipse.persistence.tools.utility.SimpleThreadFactory;
import org.eclipse.persistence.tools.utility.command.AbstractAsynchronousCommandExecutor;
import org.eclipse.persistence.tools.utility.command.Command;
import org.eclipse.persistence.tools.utility.command.ExtendedCommandExecutor;
import org.eclipse.persistence.tools.utility.command.SimpleStatefulExtendedCommandExecutor;
import org.eclipse.persistence.tools.utility.command.StatefulExtendedCommandExecutor;
import org.eclipse.persistence.tools.utility.command.SynchronizingCommand;

public class AsynchronousExtendedCommandExecutor
extends AbstractAsynchronousCommandExecutor<StatefulExtendedCommandExecutor>
implements StatefulExtendedCommandExecutor {
    public AsynchronousExtendedCommandExecutor(ExceptionHandler exceptionHandler) {
        this(null, exceptionHandler);
    }

    public AsynchronousExtendedCommandExecutor(String threadName, ExceptionHandler exceptionHandler) {
        this(new SimpleStatefulExtendedCommandExecutor(ExtendedCommandExecutor.Default.instance()), SimpleThreadFactory.instance(), threadName, exceptionHandler);
    }

    public AsynchronousExtendedCommandExecutor(StatefulExtendedCommandExecutor commandExecutor, ThreadFactory threadFactory, String threadName, ExceptionHandler exceptionHandler) {
        super(commandExecutor, threadFactory, threadName, exceptionHandler);
    }

    public AsynchronousExtendedCommandExecutor(Config config) {
        super(config);
    }

    @Override
    public void waitToExecute(Command command) throws InterruptedException {
        SynchronizingCommand syncCommand = new SynchronizingCommand();
        this.execute(syncCommand);
        try {
            syncCommand.waitForExecution();
            ((StatefulExtendedCommandExecutor)this.commandExecutor).waitToExecute(command);
        }
        finally {
            syncCommand.release();
        }
    }

    @Override
    public boolean waitToExecute(Command command, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitToExecute(command);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        SynchronizingCommand syncCommand = new SynchronizingCommand();
        this.execute(syncCommand);
        try {
            if (syncCommand.waitForExecution(timeout)) {
                timeout = stop - System.currentTimeMillis();
                boolean bl = timeout > 0L && ((StatefulExtendedCommandExecutor)this.commandExecutor).waitToExecute(command, timeout);
                return bl;
            }
            return false;
        }
        finally {
            syncCommand.release();
        }
    }

    public static interface Config
    extends AbstractAsynchronousCommandExecutor.Config<StatefulExtendedCommandExecutor> {
    }

    public static class SimpleConfig
    extends AbstractAsynchronousCommandExecutor.SimpleConfig<StatefulExtendedCommandExecutor>
    implements Config {
        public SimpleConfig() {
        }

        public SimpleConfig(StatefulExtendedCommandExecutor commandExecutor, ThreadFactory threadFactory, String threadName, ExceptionHandler exceptionHandler) {
            super(commandExecutor, threadFactory, threadName, exceptionHandler);
        }

        @Override
        protected StatefulExtendedCommandExecutor buildDefaultCommandExecutor() {
            return new SimpleStatefulExtendedCommandExecutor();
        }
    }
}

