/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.persistence.tools.utility.collection.Queue;

public class LinkedQueue<E>
implements Queue<E>,
Cloneable,
Serializable {
    private LinkedList<E> elements;
    private static final long serialVersionUID = 1L;

    public LinkedQueue() {
        this.elements = new LinkedList();
    }

    public LinkedQueue(Collection<? extends E> c) {
        this.elements = new LinkedList<E>(c);
    }

    @Override
    public void enqueue(E element) {
        this.elements.addLast(element);
    }

    @Override
    public E dequeue() {
        return this.elements.removeFirst();
    }

    @Override
    public E peek() {
        return this.elements.getFirst();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public LinkedQueue<E> clone() {
        try {
            LinkedList list;
            LinkedQueue clone = (LinkedQueue)super.clone();
            clone.elements = list = (LinkedList)this.elements.clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return this.elements.toString();
    }
}

