/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.ArrayTools;
import org.eclipse.persistence.tools.utility.ObjectTools;

public abstract class AbstractRepeatingElementList<E>
implements List<E>,
Serializable {
    private final int size;
    private static final long serialVersionUID = 1L;

    protected AbstractRepeatingElementList(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Invalid size: " + size);
        }
        this.size = size;
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c.isEmpty()) {
            return false;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.addAll(c);
    }

    @Override
    public void clear() {
        if (this.size != 0) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.elementIs(o) && this.size > 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c.isEmpty()) {
            return true;
        }
        if (this.size == 0) {
            return false;
        }
        Iterator<?> iterator = c.iterator();
        while (iterator.hasNext()) {
            if (!this.elementIsNot(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public E get(int index) {
        this.checkIndex(index);
        return this.getElement();
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    @Override
    public int indexOf(Object o) {
        return this.elementIs(o) && this.size > 0 ? 0 : -1;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return this.iterator(this.size);
    }

    protected abstract Iterator<E> iterator(int var1);

    @Override
    public int lastIndexOf(Object o) {
        return this.elementIs(o) && this.size > 0 ? this.size - 1 : -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator_(this.size);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.listIterator_(this.size - index);
    }

    protected abstract ListIterator<E> listIterator_(int var1);

    @Override
    public boolean remove(Object o) {
        if (this.size > 0 && this.elementIs(o)) {
            throw new UnsupportedOperationException();
        }
        return false;
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.size > 0 && c.contains(this.getElement())) {
            throw new UnsupportedOperationException();
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.size > 0 && !c.contains(this.getElement())) {
            throw new UnsupportedOperationException();
        }
        return false;
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.subList(toIndex - fromIndex);
    }

    protected abstract List<E> subList(int var1);

    @Override
    public Object[] toArray() {
        return ArrayTools.fill(new Object[this.size], this.getElement());
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int sz = this.size;
        return ArrayTools.fill(a.length >= sz ? a : ArrayTools.newInstance(a, sz), 0, sz, this.getElement());
    }

    private boolean elementIsNot(Object o) {
        return !this.elementIs(o);
    }

    private boolean elementIs(Object o) {
        return ObjectTools.equals(o, this.getElement());
    }

    protected abstract E getElement();

    public String toString() {
        return ObjectTools.toString((Object)this, this.size);
    }
}

