/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.beanvalidation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.beanvalidation.Address;
import org.eclipse.persistence.testing.models.jpa.beanvalidation.BeanValidationTableCreator;
import org.eclipse.persistence.testing.models.jpa.beanvalidation.Employee;

public class BeanValidationJunitTest
extends JUnitTestCase {
    public static final int EMPLOYEE_PK = 1;
    public static final int PROJECT_PK = 1;

    public BeanValidationJunitTest() {
    }

    public BeanValidationJunitTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("BeanValidationJunitTest");
        if (!JUnitTestCase.isJPA10()) {
            suite.addTest((Test)new BeanValidationJunitTest("testSetup"));
            suite.addTest((Test)new BeanValidationJunitTest("testPersistWithInvalidData"));
            suite.addTest((Test)new BeanValidationJunitTest("testEmbeddedWithInvalidData"));
            suite.addTest((Test)new BeanValidationJunitTest("testUpdateWithInvalidData"));
            suite.addTest((Test)new BeanValidationJunitTest("testRemoveWithInvalidData"));
            suite.addTest((Test)new BeanValidationJunitTest("testTraversableResolverPreventsLoadingOfLazyRelationships"));
            suite.addTest((Test)new BeanValidationJunitTest("testTraversableResolverPreventsTraversingRelationshipdMultipleTimes"));
        }
        return suite;
    }

    public void testSetup() {
        new BeanValidationTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)"beanvalidation"));
        EntityManager em = this.createEntityManager();
        this.createEmployeeProject(em);
    }

    public void createEmployeeProject(EntityManager em) {
        try {
            this.beginTransaction(em);
            Employee e1 = new Employee(1, this.getFilledStringOfLength(4), 1000L);
            org.eclipse.persistence.testing.models.jpa.beanvalidation.Project p1 = new org.eclipse.persistence.testing.models.jpa.beanvalidation.Project(1, "proj");
            org.eclipse.persistence.testing.models.jpa.beanvalidation.Project p2 = new org.eclipse.persistence.testing.models.jpa.beanvalidation.Project(2, "proj");
            em.persist((Object)p1);
            em.persist((Object)p2);
            ArrayList<org.eclipse.persistence.testing.models.jpa.beanvalidation.Project> projects = new ArrayList<org.eclipse.persistence.testing.models.jpa.beanvalidation.Project>();
            projects.add(p1);
            projects.add(p2);
            e1.setProjects(projects);
            e1.setManagedProject(p1);
            em.persist((Object)e1);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public String getFilledStringOfLength(int length) {
        char[] stringChars = new char[length];
        Arrays.fill(stringChars, 'a');
        return new String(stringChars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPersistWithInvalidData() {
        EntityManager em = this.createEntityManager();
        boolean gotConstraintViolations = false;
        String invalidName = this.getFilledStringOfLength(6);
        try {
            this.beginTransaction(em);
            Employee e1 = new Employee(100, invalidName, 1000L);
            em.persist((Object)e1);
        }
        catch (ConstraintViolationException e) {
            BeanValidationJunitTest.assertTrue((String)"Transaction not marked for roll back when ConstraintViolation is thrown", (boolean)this.getRollbackOnly(em));
            Set constraintViolations = e.getConstraintViolations();
            ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
            Object invalidaValue = constraintViolation.getInvalidValue();
            BeanValidationJunitTest.assertTrue((String)("Invalid value should be " + invalidName), (boolean)invalidName.equals(invalidaValue));
            gotConstraintViolations = true;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        BeanValidationJunitTest.assertTrue((String)"Did not get Constraint Violation while persisting invalid data ", (boolean)gotConstraintViolations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmbeddedWithInvalidData() {
        EntityManager em = this.createEntityManager();
        boolean gotConstraintViolations = false;
        try {
            this.beginTransaction(em);
            Employee e1 = new Employee(100, "name", 1000L);
            Address address = new Address("street", "city", "state");
            e1.setAddress(address);
            em.persist((Object)e1);
        }
        catch (ConstraintViolationException e) {
            BeanValidationJunitTest.assertTrue((String)"Transaction not marked for roll back when ConstraintViolation is thrown", (boolean)this.getRollbackOnly(em));
            gotConstraintViolations = true;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        BeanValidationJunitTest.assertTrue((String)"Did not get Constraint Violation while persisting invalid data ", (boolean)gotConstraintViolations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateWithInvalidData() {
        EntityManager em = this.createEntityManager();
        boolean gotConstraintViolations = false;
        String invalidName = this.getFilledStringOfLength(6);
        try {
            this.beginTransaction(em);
            Employee e = (Employee)em.find(Employee.class, (Object)1);
            e.setName(invalidName);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            BeanValidationJunitTest.assertFalse((String)"Transaction not marked for roll back when ConstraintViolation is thrown", (boolean)this.isTransactionActive(em));
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof ConstraintViolationException)) continue;
                ConstraintViolationException cve = (ConstraintViolationException)cause;
                Set constraintViolations = cve.getConstraintViolations();
                ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolations.iterator().next();
                BeanValidationJunitTest.assertTrue((String)("Invalid value should be " + invalidName), (boolean)invalidName.equals(constraintViolation.getInvalidValue()));
                gotConstraintViolations = true;
                break;
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        BeanValidationJunitTest.assertTrue((String)"Did not get Constraint Violation while updating with invalid data ", (boolean)gotConstraintViolations);
    }

    public void testRemoveWithInvalidData() {
        EntityManager em = this.createEntityManager();
        boolean removeSuccessfull = false;
        int EMPLOYEE_PK_TO_REMOVE = 2;
        try {
            this.beginTransaction(em);
            Employee e1 = new Employee(2, this.getFilledStringOfLength(4), 1000L);
            em.persist((Object)e1);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        try {
            this.beginTransaction(em);
            Employee e = (Employee)em.find(Employee.class, (Object)2);
            e.setName(this.getFilledStringOfLength(6));
            em.remove((Object)e);
            this.commitTransaction(em);
            removeSuccessfull = true;
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        this.closeEntityManager(em);
        BeanValidationJunitTest.assertTrue((String)"Automatic Validation should not be executed for remove", (boolean)removeSuccessfull);
    }

    public void testTraversableResolverPreventsLoadingOfLazyRelationships() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        Employee employee = null;
        try {
            this.beginTransaction(em);
            employee = (Employee)em.find(Employee.class, (Object)1);
            employee.setName(this.getFilledStringOfLength(3));
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
        Project project = this.getDatabaseSession().getProject();
        BeanValidationJunitTest.assertTrue((String)"Lazy field should not be instantiated because of validation", (!this.isInstantiated(employee, "projects", project) ? 1 : 0) != 0);
        BeanValidationJunitTest.assertTrue((String)"Lazy field should not be instantiated because of validation", (!this.isInstantiated(employee, "managedProject", project) ? 1 : 0) != 0);
    }

    public void testTraversableResolverPreventsTraversingRelationshipdMultipleTimes() {
    }

    private boolean isInstantiated(Object entityObject, String attributeName, Project project) {
        ForeignReferenceMapping mapping = (ForeignReferenceMapping)project.getDescriptor(Employee.class).getObjectBuilder().getMappingForAttributeName(attributeName);
        Object attributeValue = mapping.getAttributeAccessor().getAttributeValueFromObject(entityObject);
        return mapping.getIndirectionPolicy().objectIsInstantiatedOrChanged(attributeValue);
    }

    public String getPersistenceUnitName() {
        return "beanvalidation";
    }
}

