/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import java.util.Vector;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class MultipleDeleteFromIdentityMapTest
extends TestCase {
    public IdentityMap map;
    public Vector primaryKeys;
    public Vector deletionKeys;
    public Vector originalObjects;
    public Vector deletedObjects;
    public Vector retrievedObjects;

    public MultipleDeleteFromIdentityMapTest(IdentityMap map, Vector insertionKeys, Vector insertionObjects, Vector deletionKeys) {
        this.map = map;
        this.primaryKeys = insertionKeys;
        this.originalObjects = insertionObjects;
        this.deletionKeys = deletionKeys;
    }

    public int identityIndexOf(Vector collection, Object target) {
        for (int index = collection.size(); index > 0; --index) {
            if (collection.elementAt(index) != target) continue;
            return index;
        }
        return -1;
    }

    public void test() {
        Vector key;
        int index;
        for (index = 0; index < this.primaryKeys.size(); ++index) {
            key = (Vector)this.primaryKeys.elementAt(index);
            Object value = this.originalObjects.elementAt(index);
            this.map.put((Object)key, value, null, 0L);
        }
        this.deletedObjects = new Vector();
        for (index = 0; index < this.deletionKeys.size(); ++index) {
            key = (Vector)this.deletionKeys.elementAt(index);
            this.deletedObjects.addElement(this.map.remove((Object)key, null));
        }
        this.retrievedObjects = new Vector();
        for (index = 0; index < this.primaryKeys.size(); ++index) {
            key = (Vector)this.primaryKeys.elementAt(index);
            this.retrievedObjects.addElement(this.map.get((Object)key));
        }
    }

    public void verify() {
        int numberOfOriginalObjects = this.originalObjects.size();
        int expectedSize = numberOfOriginalObjects - this.deletionKeys.size();
        for (int index = 0; index < this.deletionKeys.size(); ++index) {
            Vector key = (Vector)this.deletionKeys.elementAt(index);
            int originalPosition = this.primaryKeys.indexOf(key);
            Object deletedObject = this.deletedObjects.elementAt(index);
            if (originalPosition >= 0) {
                expectedSize += this.verifyMatchesOriginalObject(deletedObject, originalPosition);
                continue;
            }
            this.verifyDeleteReturnValue(key, deletedObject);
        }
        int numberOfDeletedObjects = numberOfOriginalObjects + expectedSize;
        if (this.map.getSize() != numberOfDeletedObjects) {
            throw new TestErrorException(numberOfOriginalObjects + " were registered in the identity map " + "and " + numberOfDeletedObjects + " were deleted but " + this.map.getSize() + "objects are in the map rather than " + expectedSize + " as expected.");
        }
    }

    public void verifyDeleteReturnValue(Vector key, Object deletedObject) {
        if (deletedObject != null) {
            throw new TestErrorException("Deleted primary key" + key + " was not in the identity map, but the deletion operation returned " + deletedObject + " instead of null as expected.");
        }
    }

    public int verifyMatchesOriginalObject(Object deletedObject, int originalPosition) {
        Object originalObject = this.originalObjects.elementAt(originalPosition);
        if (originalObject == deletedObject) {
            return -1;
        }
        throw new TestErrorException("Registered object " + originalObject + " stored in identity map was not identical to " + deletedObject + ", the object returned from the remove operation with the original " + "object's primary key.");
    }
}

