/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers.rcm;

import java.util.Iterator;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.optimisticlocking.ListHolder;
import org.eclipse.persistence.testing.models.optimisticlocking.ListItem;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServer;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServersModel;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.ConfigurableCacheSyncDistributedTest;

public class OrderedListNewObjectTest
extends ConfigurableCacheSyncDistributedTest {
    public OrderedListNewObjectTest() {
        this.cacheSyncConfigValues.put(ListHolder.class, new Integer(3));
        this.cacheSyncConfigValues.put(ListItem.class, new Integer(3));
    }

    @Override
    public void setup() {
        super.setup();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        ListHolder holder = new ListHolder();
        holder = (ListHolder)uow.registerObject((Object)holder);
        ListItem item = new ListItem();
        item.setDescription("test");
        item = (ListItem)uow.registerObject((Object)item);
        holder.getItems().add(item);
        item.setHolder(holder);
        uow.commit();
    }

    public void test() {
        DistributedServer server = (DistributedServer)DistributedServersModel.getDistributedServers().get(0);
        ListHolder holder = (ListHolder)server.getDistributedSession().readObject(ListHolder.class);
        holder.getItems().size();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        holder = (ListHolder)uow.readObject(ListHolder.class);
        ListItem item = holder.getItems().get(0);
        uow.registerObject((Object)item);
        uow.deleteObject((Object)item);
        uow.deleteObject((Object)holder);
        uow.commit();
        uow = this.getSession().acquireUnitOfWork();
        holder = new ListHolder();
        holder = (ListHolder)uow.registerObject((Object)holder);
        item = new ListItem();
        item.setDescription("test");
        item = (ListItem)uow.registerObject((Object)item);
        holder.getItems().add(item);
        item.setHolder(holder);
        uow.commit();
    }

    public void verify() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        DistributedServer server = (DistributedServer)DistributedServersModel.getDistributedServers().get(0);
        ListHolder holder = (ListHolder)server.getDistributedSession().readObject(ListHolder.class);
        if (holder.getItems().size() != 1) {
            throw new TestErrorException("Incorrect number of items");
        }
    }

    @Override
    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        ListHolder holder = (ListHolder)uow.readObject(ListHolder.class);
        Iterator<ListItem> i = holder.getItems().iterator();
        while (i.hasNext()) {
            uow.deleteObject((Object)i.next());
        }
        uow.deleteObject((Object)holder);
        uow.commit();
        super.reset();
    }
}

