/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.List;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWDescriptorHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWClassIndicatorValue
extends MWModel {
    private volatile Object indicatorValue;
    public static final String INDICATOR_VALUE_PROPERTY = "indicatorValue";
    private MWDescriptorHandle descriptorValueHandle;
    public static final String DESCRIPTOR_PROPERTY = "descriptorValue";
    private volatile boolean include;
    public static final String INCLUDE_PROPERTY = "include";

    private MWClassIndicatorValue() {
    }

    MWClassIndicatorValue(MWClassIndicatorFieldPolicy parent, MWMappingDescriptor descriptorValue, Object indicatorValue) {
        super(parent);
        this.descriptorValueHandle.setDescriptor(descriptorValue);
        this.indicatorValue = indicatorValue;
        if (descriptorValue != null && descriptorValue.getMWClass().isInstantiable() && (descriptorValue.getMWClass().zeroArgumentConstructor() != null || descriptorValue.hasActiveInstantiationPolicy())) {
            this.include = true;
        }
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.descriptorValueHandle = new MWDescriptorHandle(this, this.buildDescriptorValueScrubber());
    }

    private MWClassIndicatorFieldPolicy getPolicy() {
        return (MWClassIndicatorFieldPolicy)this.getParent();
    }

    public boolean isInclude() {
        return this.include;
    }

    public void setInclude(boolean include) {
        boolean oldInclude = this.include;
        this.include = include;
        if (!include) {
            this.setIndicatorValue(null);
        }
        this.firePropertyChanged(INCLUDE_PROPERTY, oldInclude, this.include);
    }

    public MWDescriptor getDescriptorValue() {
        return this.descriptorValueHandle.getDescriptor();
    }

    public void setDescriptorValue(MWDescriptor descriptor) {
        MWDescriptor oldValue = this.getDescriptorValue();
        this.descriptorValueHandle.setDescriptor(descriptor);
        this.firePropertyChanged(DESCRIPTOR_PROPERTY, oldValue, this.getDescriptorValue());
    }

    public Object getIndicatorValue() {
        return this.indicatorValue;
    }

    public String getIndicatorValueAsString() {
        return (String)ConversionManager.getDefaultManager().convertObject(this.indicatorValue, String.class);
    }

    public void setIndicatorValue(Object newValue) {
        Object oldValue = this.indicatorValue;
        this.indicatorValue = newValue;
        this.firePropertyChanged(INDICATOR_VALUE_PROPERTY, oldValue, newValue);
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.descriptorValueHandle);
    }

    private MWHandle.NodeReferenceScrubber buildDescriptorValueScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWClassIndicatorValue.this.descriptorRemoved();
            }

            public String toString() {
                return "MWClassIndicatorValue.buildDescriptorValueScrubber()";
            }
        };
    }

    void descriptorRemoved() {
        this.getPolicy().removeIndicator(this);
    }

    @Override
    public void descriptorReplaced(MWDescriptor oldDescriptor, MWDescriptor newDescriptor) {
        super.descriptorReplaced(oldDescriptor, newDescriptor);
        if (this.getDescriptorValue() == oldDescriptor) {
            this.setDescriptorValue(newDescriptor);
        }
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append(this.getIndicatorValue());
        sb.append(" -> ");
        if (this.getDescriptorValue() != null) {
            sb.append(this.getDescriptorValue().getMWClass().shortName());
        } else {
            sb.append("null");
        }
    }

    @Override
    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.checkClassIndicatorValue(newProblems);
    }

    private void checkClassIndicatorValue(List newProblems) {
        if (this.isInclude() && (this.getIndicatorValue() == null || this.getIndicatorValueAsString().length() == 0)) {
            newProblems.add(this.buildProblem("0055", this.getDescriptorValue().displayStringWithPackage()));
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWClassIndicatorValue.class);
        XMLDirectMapping indicatorValueMapping = new XMLDirectMapping();
        indicatorValueMapping.setAttributeName(INDICATOR_VALUE_PROPERTY);
        indicatorValueMapping.setGetMethodName("getIndicatorValueForTopLink");
        indicatorValueMapping.setSetMethodName("setIndicatorValueForTopLink");
        indicatorValueMapping.setXPath("indicator/text()");
        descriptor.addMapping((DatabaseMapping)indicatorValueMapping);
        XMLCompositeObjectMapping descriptorValueMapping = new XMLCompositeObjectMapping();
        descriptorValueMapping.setAttributeName("descriptorValueHandle");
        descriptorValueMapping.setGetMethodName("getDescriptorValueHandleForTopLink");
        descriptorValueMapping.setSetMethodName("setDescriptorValueHandleForTopLink");
        descriptorValueMapping.setReferenceClass(MWDescriptorHandle.class);
        descriptorValueMapping.setXPath("descriptor-value-handle");
        descriptor.addMapping((DatabaseMapping)descriptorValueMapping);
        return descriptor;
    }

    private MWDescriptorHandle getDescriptorValueHandleForTopLink() {
        return this.descriptorValueHandle.getDescriptor() == null ? null : this.descriptorValueHandle;
    }

    private void setDescriptorValueHandleForTopLink(MWDescriptorHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildDescriptorValueScrubber();
        this.descriptorValueHandle = handle == null ? new MWDescriptorHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    private Object getIndicatorValueForTopLink() {
        return this.getIndicatorValueAsString();
    }

    private void setIndicatorValueForTopLink(Object indicatorValue) {
        this.indicatorValue = indicatorValue;
    }

    @Override
    public void postProjectBuild() {
        super.postProjectBuild();
        this.include = true;
    }
}

