/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational;

import java.util.Iterator;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.TableCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectNode;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ExtendedListValueModelWrapper;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;

public class RelationalProjectComponentFactory
extends SwingComponentFactory {
    public static ListChooser buildTableChooser(PropertyValueModel mwModelHolder, PropertyValueModel selectedTableHolder, DefaultListChooserDialog.Builder dialogBuilder, WorkbenchContextHolder contextHolder) {
        DefaultListChooser listChooser = new DefaultListChooser(new ComboBoxModelAdapter(RelationalProjectComponentFactory.buildExtendedTablesHolder(mwModelHolder), selectedTableHolder), contextHolder, RelationalProjectComponentFactory.buildTableNodeSelector(contextHolder), dialogBuilder);
        listChooser.setRenderer(RelationalProjectComponentFactory.buildMWTableListCellRenderer(contextHolder.getWorkbenchContext().getApplicationContext().getResourceRepository()));
        return listChooser;
    }

    private static ValueModel buildDatabaseAdapter(PropertyValueModel mwModelHolder) {
        return new TransformationPropertyValueModel(mwModelHolder){

            @Override
            protected Object transform(Object value) {
                return value == null ? null : ((MWModel)value).getDatabase();
            }

            @Override
            protected Object reverseTransform(Object value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static ListValueModel buildExtendedTablesHolder(PropertyValueModel mwModelHolder) {
        return new ExtendedListValueModelWrapper(RelationalProjectComponentFactory.buildSortedTablesHolder(RelationalProjectComponentFactory.buildDatabaseAdapter(mwModelHolder)));
    }

    private static ListValueModel buildSortedTablesHolder(ValueModel databaseHolder) {
        return new SortedListValueModelAdapter(RelationalProjectComponentFactory.buildTableNameAdapter(databaseHolder));
    }

    private static ListValueModel buildTableNameAdapter(ValueModel databaseHolder) {
        return new ItemPropertyListValueModelAdapter(RelationalProjectComponentFactory.buildTablesAdapter(databaseHolder), "qualifiedName");
    }

    private static CollectionValueModel buildTablesAdapter(ValueModel databaseHolder) {
        return new CollectionAspectAdapter(databaseHolder, "tables"){

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWDatabase)this.subject).tables();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWDatabase)this.subject).tablesSize();
            }
        };
    }

    private static ListCellRenderer buildMWTableListCellRenderer(ResourceRepository resourceRepository) {
        return new AdaptableListCellRenderer(new TableCellRendererAdapter(resourceRepository));
    }

    public static NodeSelector buildTableNodeSelector(final WorkbenchContextHolder contextHolder) {
        return new NodeSelector(){

            @Override
            public void selectNodeFor(Object item) {
                RelationalProjectNode projectNode = (RelationalProjectNode)contextHolder.getWorkbenchContext().getNavigatorSelectionModel().getSelectedProjectNodes()[0];
                projectNode.selectTableNodeFor((MWTable)item, contextHolder.getWorkbenchContext().getNavigatorSelectionModel());
            }
        };
    }
}

