/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.persistence.tools.workbench.framework.context.PreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.ComponentAligner;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.uitools.app.BufferedPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.adapters.PreferencePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;
import org.eclipse.persistence.tools.workbench.utility.string.BidiStringConverter;

final class MappingsPreferencesPage
extends AbstractPanel {
    private ComponentAligner aligner;
    private final String NO_OPTION = TriStateBoolean.FALSE.toString();
    private final String PROMPT_OPTION = TriStateBoolean.UNDEFINED.toString();
    private final String YES_OPTION = TriStateBoolean.TRUE.toString();

    MappingsPreferencesPage(PreferencesContext context) {
        super(context);
        this.intializeLayout();
    }

    private void applyConverter(PreferencePropertyValueModel adapter) {
        adapter.setConverter(new BidiStringConverter(){

            public Object convertToObject(String value) {
                return this.convertToString(value);
            }

            public String convertToString(Object value) {
                if (MappingsPreferencesPage.this.YES_OPTION.equals(value)) {
                    return MappingsPreferencesPage.this.YES_OPTION;
                }
                if (MappingsPreferencesPage.this.NO_OPTION.equals(value)) {
                    return MappingsPreferencesPage.this.NO_OPTION;
                }
                return MappingsPreferencesPage.this.PROMPT_OPTION;
            }
        });
    }

    private PropertyValueModel buildBufferedAdapter(PropertyValueModel valueHolder) {
        return new BufferedPropertyValueModel(valueHolder, this.getPreferencesContext().getBufferTrigger());
    }

    private ButtonModel buildButtonAdapter(PropertyValueModel valueHolder, String buttonValue) {
        return new RadioButtonModelAdapter(valueHolder, buttonValue);
    }

    private PropertyValueModel buildChangeQueryFormatAdapter() {
        PreferencePropertyValueModel adapter = new PreferencePropertyValueModel(this.preferences(), "query change query format");
        this.applyConverter(adapter);
        return this.buildBufferedAdapter(adapter);
    }

    private JComponent buildChangeQueryFormatPromptGroupBox() {
        GridBagConstraints constraints = new GridBagConstraints();
        PropertyValueModel changeQueryFormatHolder = this.buildChangeQueryFormatAdapter();
        JPanel container = this.buildGroupBox("PREFERENCES.MAPPINGS.QUERY.CHANGE_QUERY_FORMAT");
        JRadioButton yesButton = this.buildRadioButton("PREFERENCES.MAPPINGS.QUERY.CHANGE_QUERY_FORMAT.YES", this.buildButtonAdapter(changeQueryFormatHolder, this.YES_OPTION));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)yesButton, constraints);
        this.aligner.add(yesButton);
        JRadioButton noButton = this.buildRadioButton("PREFERENCES.MAPPINGS.QUERY.CHANGE_QUERY_FORMAT.NO", this.buildButtonAdapter(changeQueryFormatHolder, this.NO_OPTION));
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 20, 0, 0);
        container.add((Component)noButton, constraints);
        this.aligner.add(noButton);
        JRadioButton promptButton = this.buildRadioButton("PREFERENCES.MAPPINGS.QUERY.CHANGE_QUERY_FORMAT.PROMPT", this.buildButtonAdapter(changeQueryFormatHolder, this.PROMPT_OPTION));
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 20, 0, 0);
        container.add((Component)promptButton, constraints);
        this.aligner.add(promptButton);
        this.addHelpTopicId(container, "preferences.mappings.query.changeQueryFormat");
        return container;
    }

    private PropertyValueModel buildChangeQueryTypeAdapter() {
        PreferencePropertyValueModel adapter = new PreferencePropertyValueModel(this.preferences(), "query change query type");
        this.applyConverter(adapter);
        return this.buildBufferedAdapter(adapter);
    }

    private JComponent buildChangeQueryTypePromptGroupBox() {
        GridBagConstraints constraints = new GridBagConstraints();
        PropertyValueModel changeQueryTypeHolder = this.buildChangeQueryTypeAdapter();
        JPanel container = this.buildGroupBox("PREFERENCES.MAPPINGS.QUERY.CHANGE_QUERY_TYPE");
        JRadioButton yesButton = this.buildRadioButton("PREFERENCES.MAPPINGS.QUERY.CHANGE_QUERY_TYPE.YES", this.buildButtonAdapter(changeQueryTypeHolder, this.YES_OPTION));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)yesButton, constraints);
        this.aligner.add(yesButton);
        JRadioButton noButton = this.buildRadioButton("PREFERENCES.MAPPINGS.QUERY.CHANGE_QUERY_TYPE.NO", this.buildButtonAdapter(changeQueryTypeHolder, this.NO_OPTION));
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 20, 0, 0);
        container.add((Component)noButton, constraints);
        this.aligner.add(noButton);
        JRadioButton promptButton = this.buildRadioButton("PREFERENCES.MAPPINGS.QUERY.CHANGE_QUERY_TYPE.PROMPT", this.buildButtonAdapter(changeQueryTypeHolder, this.PROMPT_OPTION));
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 20, 0, 0);
        container.add((Component)promptButton, constraints);
        this.aligner.add(promptButton);
        this.addHelpTopicId(container, "preferences.mappings.query.changeQueryType");
        return container;
    }

    private JPanel buildGroupBox(String titleKey) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(this.buildTitledBorder(titleKey));
        return panel;
    }

    private void intializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.aligner = new ComponentAligner();
        JComponent changeQueryTypeGroupBox = this.buildChangeQueryTypePromptGroupBox();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)changeQueryTypeGroupBox, constraints);
        JComponent changeQueryFormatGroupBox = this.buildChangeQueryFormatPromptGroupBox();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)changeQueryFormatGroupBox, constraints);
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.add((Component)new Spacer(), constraints);
        this.addHelpTopicId(this, "preferences.mappings");
    }
}

