/*******************************************************************************
 * Copyright (c) 2005, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.tools.utility.tests.collection.CommonUtilityCollectionTests;
import org.eclipse.persistence.tools.utility.tests.command.CommonUtilityCommandTests;
import org.eclipse.persistence.tools.utility.tests.enumeration.CommonUtilityEnumerationTests;
import org.eclipse.persistence.tools.utility.tests.filter.CommonUtilityFilterTests;
import org.eclipse.persistence.tools.utility.tests.io.CommonUtilityIOTests;
import org.eclipse.persistence.tools.utility.tests.iterable.CommonUtilityIterableTests;
import org.eclipse.persistence.tools.utility.tests.iterator.CommonUtilityIteratorTests;
import org.eclipse.persistence.tools.utility.tests.jdbc.CommonUtilityJDBCTests;
import org.eclipse.persistence.tools.utility.tests.model.CommonUtilityModelTests;
import org.eclipse.persistence.tools.utility.tests.node.CommonUtilityNodeTests;
import org.eclipse.persistence.tools.utility.tests.reference.CommonUtilityReferenceTests;
import org.eclipse.persistence.tools.utility.tests.transformer.CommonUtilityTransformerTests;

/**
 * decentralize test creation code
 */
public class CommonUtilityTests {

	public static Test suite() {
		TestSuite suite = new TestSuite(CommonUtilityTests.class.getPackage().getName());

		suite.addTest(CommonUtilityCollectionTests.suite());
		suite.addTest(CommonUtilityCommandTests.suite());
		suite.addTest(CommonUtilityEnumerationTests.suite());
		suite.addTest(CommonUtilityFilterTests.suite());
		suite.addTest(CommonUtilityIOTests.suite());
		suite.addTest(CommonUtilityIterableTests.suite());
		suite.addTest(CommonUtilityIteratorTests.suite());
		suite.addTest(CommonUtilityJDBCTests.suite());
		suite.addTest(CommonUtilityModelTests.suite());
		suite.addTest(CommonUtilityNodeTests.suite());
		suite.addTest(CommonUtilityReferenceTests.suite());
		suite.addTest(CommonUtilityTransformerTests.suite());

		suite.addTestSuite(ArrayToolsTests.class);
		suite.addTestSuite(BitToolsTests.class);
		suite.addTestSuite(BooleanToolsTests.class);
		suite.addTestSuite(ByteArrayToolsTests.class);
		suite.addTestSuite(CancelExceptionTests.class);
		suite.addTestSuite(CharacterToolsTests.class);
		suite.addTestSuite(CharArrayToolsTests.class);
		suite.addTestSuite(ClassToolsTests.class);
		suite.addTestSuite(ClassNameToolsTests.class);
		suite.addTestSuite(ClasspathTests.class);
		suite.addTestSuite(CollectingExceptionHandlerTests.class);
		suite.addTestSuite(CompositeExceptionHandlerTests.class);
		suite.addTestSuite(CompositeExceptionTests.class);
		suite.addTestSuite(CompositeMultiThreadedExceptionHandlerTests.class);
		suite.addTestSuite(ExceptionHandlerTests.class);
		suite.addTestSuite(ListenerListTests.class);
		suite.addTestSuite(NameToolsTests.class);
		suite.addTestSuite(ObjectToolsTests.class);
		suite.addTestSuite(PrintStreamExceptionHandlerTests.class);
		suite.addTestSuite(PrintWriterExceptionHandlerTests.class);
		suite.addTestSuite(RangeTests.class);
		suite.addTestSuite(ReverseComparatorTests.class);
		suite.addTestSuite(SimpleAssociationTests.class);
		suite.addTestSuite(SimpleJavaTypeTests.class);
		suite.addTestSuite(SimpleMethodSignatureTests.class);
		suite.addTestSuite(StackTraceTests.class);
		suite.addTestSuite(StringBufferToolsTests.class);
		suite.addTestSuite(StringBuilderToolsTests.class);
		suite.addTestSuite(StringToolsTests.class);
		suite.addTestSuite(SystemToolsTests.class);
		suite.addTestSuite(TypeDeclarationToolsTests.class);
		suite.addTestSuite(VersionComparatorTests.class);
		suite.addTestSuite(XMLToolsReadTests.class);
		suite.addTestSuite(XMLToolsWriteTests.class);

		return suite;
	}

	private CommonUtilityTests() {
		super();
		throw new UnsupportedOperationException();
	}
}