/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.DiscriminatorType;
import org.eclipse.persistence.tools.mapping.orm.ExternalDiscriminatorColumn;

/**
 * The external form of the discriminator column.
 *
 * @see Entity
 * @see VariableOneToOneMapping
 *
 * @version 2.5
 * @author Les Davis
 * @author Pascal Filion
 */
@SuppressWarnings("nls")
final class DiscriminatorColumn extends AbstractExternalForm
                                implements ExternalDiscriminatorColumn {

	/**
	 * The attribute name used to store and retrieve the column-definition property.
	 */
	static final String COLUMN_DEFINITION = "column-definition";

	/**
	 * The node name used to store and retrieve the {@link Element} encapsulated by this external form.
	 */
	static final String DISCRIMINATOR_COLUMN = "discriminator-column";

	/**
	 * The attribute name used to store and retrieve the discriminator-type property.
	 */
	static final String DISCRIMINATOR_TYPE = "discriminator-type";

	/**
	 * The attribute name used to store and retrieve the length property.
	 */
	static final String LENGTH = "length";

	/**
	 * The attribute name used to store and retrieve the name property.
	 */
	static final String NAME = "name";

	/**
	 * Creates a new <code>DiscriminatorColumn</code>.
	 *
	 * @param parent The parent of this external form
	 */
	DiscriminatorColumn(Entity parent) {
		super(parent);
	}

	/**
	 * Creates a new <code>DiscriminatorColumn</code>.
	 *
	 * @param parent The parent of this external form
	 */
	DiscriminatorColumn(VariableOneToOneMapping parent) {
		super(parent);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(NAME);
		names.add(DISCRIMINATOR_TYPE);
		names.add(COLUMN_DEFINITION);
		names.add(LENGTH);
		return names;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getColumnDefinition() {
		return getAttribute(COLUMN_DEFINITION);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public DiscriminatorType getDiscriminatorType() {
		return getEnumAttribute(DISCRIMINATOR_TYPE, DiscriminatorType.class);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return DISCRIMINATOR_COLUMN;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Integer getLength() {
		return getIntegerAttribute(LENGTH);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return getAttribute(NAME);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setColumnDefinition(String definition) {

		setAttribute(COLUMN_DEFINITION, definition);

		if (!hasAttributes() && !hasAnyChildren()) {
			removeSelf();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDiscriminatorType(DiscriminatorType type) {

		setAttribute(DISCRIMINATOR_TYPE, type);

		if (!hasAttributes() && !hasAnyChildren()) {
			removeSelf();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setLength(Integer length) {

		setAttribute(LENGTH, length);

		if (!hasAttributes() && !hasAnyChildren()) {
			removeSelf();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setName(String name) {

		setAttribute(NAME, name);

		if (!hasAttributes() && !hasAnyChildren()) {
			removeSelf();
		}
	}
}