/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterable;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.persistence.tools.utility.iterator.ArrayIterator;

public class ArrayIterable<E>
implements Iterable<E> {
    final E[] array;
    final int start;
    final int end;

    public ArrayIterable(E ... array) {
        this(array, 0);
    }

    public ArrayIterable(E[] array, int start) {
        this(array, start, array.length);
    }

    public ArrayIterable(E[] array, int start, int end) {
        if (start < 0 || start > array.length) {
            throw new IllegalArgumentException("start: " + start);
        }
        if (end < start || end > array.length) {
            throw new IllegalArgumentException("end: " + end);
        }
        this.array = array;
        this.start = start;
        this.end = end;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayIterator<E>(this.array, this.start, this.end);
    }

    public String toString() {
        return Arrays.toString(this.array);
    }
}

