/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.collection;

import java.io.Serializable;
import java.util.NoSuchElementException;

public interface Queue<E> {
    public void enqueue(E var1);

    public E dequeue();

    public E peek();

    public boolean isEmpty();

    public static final class Empty<E>
    implements Queue<E>,
    Serializable {
        public static final Queue INSTANCE = new Empty();
        private static final long serialVersionUID = 1L;

        public static <T> Queue<T> instance() {
            return INSTANCE;
        }

        private Empty() {
        }

        @Override
        public void enqueue(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E dequeue() {
            throw new NoSuchElementException();
        }

        @Override
        public E peek() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public String toString() {
            return "[]";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

