/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.collection.CollectionTools;

public abstract class AbstractRepeatingElementListTests
extends TestCase {
    public AbstractRepeatingElementListTests(String name) {
        super(name);
    }

    public void testBogusSize() {
        boolean exCaught = false;
        try {
            List<String> list = this.buildList(-3);
            AbstractRepeatingElementListTests.fail((String)("bogus list: " + list));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        AbstractRepeatingElementListTests.assertTrue((boolean)exCaught);
    }

    public void testAddObject() {
        List<String> list = this.buildList(3);
        boolean exCaught = false;
        try {
            list.add("foo");
            AbstractRepeatingElementListTests.fail((String)("bogus list: " + list));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        AbstractRepeatingElementListTests.assertTrue((boolean)exCaught);
    }

    public void testAddIntObject() {
        List<String> list = this.buildList(3);
        boolean exCaught = false;
        try {
            list.add(2, "foo");
            AbstractRepeatingElementListTests.fail((String)("bogus list: " + list));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        AbstractRepeatingElementListTests.assertTrue((boolean)exCaught);
    }

    public void testAddAllCollection() {
        List<String> list = this.buildList(3);
        list.addAll(Collections.emptySet());
        boolean exCaught = false;
        try {
            list.addAll((Collection<String>)CollectionTools.collection((Object[])new String[]{"foo", "bar"}));
            AbstractRepeatingElementListTests.fail((String)("bogus list: " + list));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        AbstractRepeatingElementListTests.assertTrue((boolean)exCaught);
    }

    public void testAddAllIntCollection() {
        List<String> list = this.buildList(3);
        list.addAll(1, Collections.emptySet());
        boolean exCaught = false;
        try {
            list.addAll(1, (Collection<String>)CollectionTools.collection((Object[])new String[]{"foo", "bar"}));
            AbstractRepeatingElementListTests.fail((String)("bogus list: " + list));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        AbstractRepeatingElementListTests.assertTrue((boolean)exCaught);
    }

    public void testClear() {
        List<String> list = this.buildList(0);
        list.clear();
        list = this.buildList(3);
        boolean exCaught = false;
        try {
            list.clear();
            AbstractRepeatingElementListTests.fail((String)("bogus list: " + list));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        AbstractRepeatingElementListTests.assertTrue((boolean)exCaught);
    }

    public void testContainsObject() {
        List<String> list = this.buildList(0);
        AbstractRepeatingElementListTests.assertFalse((boolean)list.contains(this.getElement()));
        AbstractRepeatingElementListTests.assertFalse((boolean)list.contains(new Object()));
        list = this.buildList(3);
        AbstractRepeatingElementListTests.assertTrue((boolean)list.contains(this.getElement()));
        AbstractRepeatingElementListTests.assertFalse((boolean)list.contains(new Object()));
    }

    public void testContainsAllCollection() {
        Set emptyCollection = Collections.emptySet();
        ArrayList<String> goodCollection = new ArrayList<String>();
        goodCollection.add(this.getElement());
        goodCollection.add(this.getElement());
        goodCollection.add(this.getElement());
        ArrayList<String> badCollection = new ArrayList<String>();
        badCollection.add(this.getElement());
        badCollection.add("bad");
        badCollection.add(this.getElement());
        List<String> list = this.buildList(0);
        AbstractRepeatingElementListTests.assertTrue((boolean)list.containsAll(emptyCollection));
        AbstractRepeatingElementListTests.assertFalse((boolean)list.containsAll(goodCollection));
        AbstractRepeatingElementListTests.assertFalse((boolean)list.containsAll(badCollection));
        list = this.buildList(3);
        AbstractRepeatingElementListTests.assertTrue((boolean)list.containsAll(emptyCollection));
        AbstractRepeatingElementListTests.assertTrue((boolean)list.containsAll(goodCollection));
        AbstractRepeatingElementListTests.assertFalse((boolean)list.containsAll(badCollection));
    }

    public void testGetInt() {
        List<String> list = this.buildList(3);
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)list.get(0));
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)list.get(1));
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)list.get(2));
        boolean exCaught = false;
        try {
            AbstractRepeatingElementListTests.fail((String)("bogus element: " + list.get(-1)));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        AbstractRepeatingElementListTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            AbstractRepeatingElementListTests.fail((String)("bogus element: " + list.get(3)));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        AbstractRepeatingElementListTests.assertTrue((boolean)exCaught);
    }

    public void testIndexOfObject() {
        List<String> list = this.buildList(3);
        AbstractRepeatingElementListTests.assertEquals((int)0, (int)list.indexOf(this.getElement()));
        AbstractRepeatingElementListTests.assertEquals((int)-1, (int)list.indexOf(new Object()));
    }

    public void testIsEmpty() {
        List<String> list = this.buildList(3);
        AbstractRepeatingElementListTests.assertFalse((boolean)list.isEmpty());
        list = this.buildList(0);
        AbstractRepeatingElementListTests.assertTrue((boolean)list.isEmpty());
    }

    public void testIterator() {
        List<String> list = this.buildList(3);
        Iterator<String> iterator = list.iterator();
        AbstractRepeatingElementListTests.assertTrue((boolean)iterator.hasNext());
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)iterator.next());
        AbstractRepeatingElementListTests.assertTrue((boolean)iterator.hasNext());
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)iterator.next());
        AbstractRepeatingElementListTests.assertTrue((boolean)iterator.hasNext());
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)iterator.next());
        AbstractRepeatingElementListTests.assertFalse((boolean)iterator.hasNext());
        boolean exCaught = false;
        try {
            iterator.remove();
            AbstractRepeatingElementListTests.fail((String)("bogus list: " + list));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        AbstractRepeatingElementListTests.assertTrue((boolean)exCaught);
        list = this.buildList(0);
        iterator = list.iterator();
        AbstractRepeatingElementListTests.assertFalse((boolean)iterator.hasNext());
    }

    public void testLastIndexOfObject() {
        List<String> list = this.buildList(3);
        AbstractRepeatingElementListTests.assertEquals((int)2, (int)list.lastIndexOf(this.getElement()));
        AbstractRepeatingElementListTests.assertEquals((int)-1, (int)list.lastIndexOf(new Object()));
    }

    public void testListIterator() {
        List<String> list = this.buildList(3);
        ListIterator<String> iterator = list.listIterator();
        this.verifyListIterator(list, iterator);
        list = this.buildList(0);
        iterator = list.listIterator();
        AbstractRepeatingElementListTests.assertFalse((boolean)iterator.hasNext());
        AbstractRepeatingElementListTests.assertFalse((boolean)iterator.hasPrevious());
    }

    public void testListIteratorInt() {
        List<String> list = this.buildList(7);
        ListIterator<String> iterator = list.listIterator(4);
        this.verifyListIterator(list, iterator);
        list = this.buildList(0);
        iterator = list.listIterator();
        AbstractRepeatingElementListTests.assertFalse((boolean)iterator.hasNext());
        AbstractRepeatingElementListTests.assertFalse((boolean)iterator.hasPrevious());
    }

    public void verifyListIterator(List<String> list, ListIterator<String> iterator) {
        AbstractRepeatingElementListTests.assertTrue((boolean)iterator.hasNext());
        AbstractRepeatingElementListTests.assertFalse((boolean)iterator.hasPrevious());
        AbstractRepeatingElementListTests.assertEquals((int)0, (int)iterator.nextIndex());
        AbstractRepeatingElementListTests.assertEquals((int)-1, (int)iterator.previousIndex());
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)iterator.next());
        AbstractRepeatingElementListTests.assertTrue((boolean)iterator.hasNext());
        AbstractRepeatingElementListTests.assertTrue((boolean)iterator.hasPrevious());
        AbstractRepeatingElementListTests.assertEquals((int)1, (int)iterator.nextIndex());
        AbstractRepeatingElementListTests.assertEquals((int)0, (int)iterator.previousIndex());
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)iterator.next());
        AbstractRepeatingElementListTests.assertTrue((boolean)iterator.hasNext());
        AbstractRepeatingElementListTests.assertTrue((boolean)iterator.hasPrevious());
        AbstractRepeatingElementListTests.assertEquals((int)2, (int)iterator.nextIndex());
        AbstractRepeatingElementListTests.assertEquals((int)1, (int)iterator.previousIndex());
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)iterator.next());
        AbstractRepeatingElementListTests.assertFalse((boolean)iterator.hasNext());
        AbstractRepeatingElementListTests.assertTrue((boolean)iterator.hasPrevious());
        AbstractRepeatingElementListTests.assertEquals((int)3, (int)iterator.nextIndex());
        AbstractRepeatingElementListTests.assertEquals((int)2, (int)iterator.previousIndex());
        boolean exCaught = false;
        try {
            AbstractRepeatingElementListTests.fail((String)("bogus element: " + iterator.next()));
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        AbstractRepeatingElementListTests.assertTrue((boolean)exCaught);
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)iterator.previous());
        AbstractRepeatingElementListTests.assertTrue((boolean)iterator.hasNext());
        AbstractRepeatingElementListTests.assertTrue((boolean)iterator.hasPrevious());
        AbstractRepeatingElementListTests.assertEquals((int)2, (int)iterator.nextIndex());
        AbstractRepeatingElementListTests.assertEquals((int)1, (int)iterator.previousIndex());
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)iterator.previous());
        AbstractRepeatingElementListTests.assertTrue((boolean)iterator.hasNext());
        AbstractRepeatingElementListTests.assertTrue((boolean)iterator.hasPrevious());
        AbstractRepeatingElementListTests.assertEquals((int)1, (int)iterator.nextIndex());
        AbstractRepeatingElementListTests.assertEquals((int)0, (int)iterator.previousIndex());
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)iterator.previous());
        AbstractRepeatingElementListTests.assertTrue((boolean)iterator.hasNext());
        AbstractRepeatingElementListTests.assertFalse((boolean)iterator.hasPrevious());
        AbstractRepeatingElementListTests.assertEquals((int)0, (int)iterator.nextIndex());
        AbstractRepeatingElementListTests.assertEquals((int)-1, (int)iterator.previousIndex());
        exCaught = false;
        try {
            AbstractRepeatingElementListTests.fail((String)("bogus element: " + iterator.previous()));
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        AbstractRepeatingElementListTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            iterator.remove();
            AbstractRepeatingElementListTests.fail((String)("bogus list: " + list));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        AbstractRepeatingElementListTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            iterator.add("foo");
            AbstractRepeatingElementListTests.fail((String)("bogus list: " + list));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        AbstractRepeatingElementListTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            iterator.set("foo");
            AbstractRepeatingElementListTests.fail((String)("bogus list: " + list));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        AbstractRepeatingElementListTests.assertTrue((boolean)exCaught);
        list = this.buildList(0);
        iterator = list.listIterator();
        AbstractRepeatingElementListTests.assertFalse((boolean)iterator.hasNext());
        AbstractRepeatingElementListTests.assertFalse((boolean)iterator.hasPrevious());
    }

    public void testRemoveObject() {
        List<String> list = this.buildList(0);
        AbstractRepeatingElementListTests.assertFalse((boolean)list.remove(this.getElement()));
        AbstractRepeatingElementListTests.assertFalse((boolean)list.remove("foo"));
        list = this.buildList(3);
        AbstractRepeatingElementListTests.assertFalse((boolean)list.remove("foo"));
        boolean exCaught = false;
        try {
            list.remove(this.getElement());
            AbstractRepeatingElementListTests.fail((String)("bogus list: " + list));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        AbstractRepeatingElementListTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveInt() {
        List<String> list = this.buildList(3);
        boolean exCaught = false;
        try {
            list.remove(0);
            AbstractRepeatingElementListTests.fail((String)("bogus list: " + list));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        AbstractRepeatingElementListTests.assertTrue((boolean)exCaught);
    }

    public void testRemoveAllCollection() {
        Set emptyCollection = Collections.emptySet();
        ArrayList<String> goodCollection = new ArrayList<String>();
        goodCollection.add("good");
        goodCollection.add("good");
        goodCollection.add("good");
        ArrayList<String> badCollection = new ArrayList<String>();
        badCollection.add("bad");
        badCollection.add(this.getElement());
        badCollection.add("bad");
        List<String> list = this.buildList(0);
        AbstractRepeatingElementListTests.assertFalse((boolean)list.removeAll(emptyCollection));
        AbstractRepeatingElementListTests.assertFalse((boolean)list.removeAll(goodCollection));
        AbstractRepeatingElementListTests.assertFalse((boolean)list.removeAll(badCollection));
        list = this.buildList(3);
        AbstractRepeatingElementListTests.assertFalse((boolean)list.removeAll(emptyCollection));
        AbstractRepeatingElementListTests.assertFalse((boolean)list.removeAll(goodCollection));
        boolean exCaught = false;
        try {
            list.removeAll(badCollection);
            AbstractRepeatingElementListTests.fail((String)("bogus list: " + list));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        AbstractRepeatingElementListTests.assertTrue((boolean)exCaught);
    }

    public void testRetainAllCollection() {
        Set emptyCollection = Collections.emptySet();
        ArrayList<String> goodCollection = new ArrayList<String>();
        goodCollection.add("good");
        goodCollection.add(this.getElement());
        goodCollection.add("good");
        ArrayList<String> badCollection = new ArrayList<String>();
        badCollection.add("bad");
        badCollection.add("bad");
        badCollection.add("bad");
        List<String> list = this.buildList(0);
        AbstractRepeatingElementListTests.assertFalse((boolean)list.retainAll(emptyCollection));
        AbstractRepeatingElementListTests.assertFalse((boolean)list.retainAll(goodCollection));
        AbstractRepeatingElementListTests.assertFalse((boolean)list.retainAll(badCollection));
        list = this.buildList(3);
        boolean exCaught = false;
        try {
            list.retainAll(emptyCollection);
            AbstractRepeatingElementListTests.fail((String)("bogus list: " + list));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        AbstractRepeatingElementListTests.assertTrue((boolean)exCaught);
        AbstractRepeatingElementListTests.assertFalse((boolean)list.retainAll(goodCollection));
        exCaught = false;
        try {
            list.retainAll(badCollection);
            AbstractRepeatingElementListTests.fail((String)("bogus list: " + list));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        AbstractRepeatingElementListTests.assertTrue((boolean)exCaught);
    }

    public void testSetIntObject() {
        List<String> list = this.buildList(3);
        boolean exCaught = false;
        try {
            list.set(0, "foo");
            AbstractRepeatingElementListTests.fail((String)("bogus list: " + list));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        AbstractRepeatingElementListTests.assertTrue((boolean)exCaught);
    }

    public void testSize() {
        List<String> list = this.buildList(3);
        AbstractRepeatingElementListTests.assertEquals((int)3, (int)list.size());
    }

    public void testSubList() {
        List<String> list = this.buildList(7);
        List<String> subList = list.subList(2, 7);
        AbstractRepeatingElementListTests.assertEquals((int)5, (int)subList.size());
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)subList.get(0));
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)subList.get(3));
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)subList.get(4));
    }

    public void testToArray() {
        List<String> list = this.buildList(7);
        Object[] array = list.toArray();
        AbstractRepeatingElementListTests.assertEquals((int)7, (int)array.length);
        AbstractRepeatingElementListTests.assertEquals((Object)this.getElement(), (Object)array[0]);
        AbstractRepeatingElementListTests.assertEquals((Object)this.getElement(), (Object)array[3]);
        AbstractRepeatingElementListTests.assertEquals((Object)this.getElement(), (Object)array[6]);
    }

    public void testToArrayObjectArray() {
        List<String> list = this.buildList(7);
        String[] array = list.toArray(new String[0]);
        AbstractRepeatingElementListTests.assertEquals((int)7, (int)array.length);
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)array[0]);
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)array[3]);
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)array[6]);
        String[] template = new String[21];
        array = list.toArray(template);
        AbstractRepeatingElementListTests.assertSame((Object)template, (Object)array);
        AbstractRepeatingElementListTests.assertEquals((int)21, (int)array.length);
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)array[0]);
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)array[3]);
        AbstractRepeatingElementListTests.assertEquals((String)this.getElement(), (String)array[6]);
        AbstractRepeatingElementListTests.assertNull((Object)array[7]);
        AbstractRepeatingElementListTests.assertNull((Object)array[20]);
    }

    public abstract List<String> buildList(int var1);

    public abstract String getElement();
}

