/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.interfaces;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.interfaces.Employee;
import org.eclipse.persistence.testing.models.interfaces.Phone;

public class VariableOneToOneDeleteTest
extends TransactionalTestCase {
    private Employee employee;

    public void setup() {
        super.setup();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee emp = (Employee)uow.registerObject((Object)Employee.example1());
        emp.setName("Guy");
        uow.commit();
    }

    public void test() {
        this.employee = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("name").equal((Object)"Guy"));
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee e = (Employee)uow.registerObject((Object)this.employee);
        e.setName("Guy Pelletier");
        Phone p = Phone.example3();
        p.setNumber("6138236262");
        e.setContact(p);
        p.setEmp(e);
        uow.deleteObject((Object)this.employee);
        uow.commit();
    }

    protected void verify() {
        if (!this.verifyDelete(this.employee)) {
            throw new TestErrorException("The object '" + this.employee + "' was not completely deleted from the database.");
        }
        if (this.getSession().readObject(Employee.class, new ExpressionBuilder().get("name").equal((Object)"Guy Pelletier")) != null) {
            throw new TestErrorException("The object '" + this.employee + "' was not completely deleted from the database.");
        }
    }
}

