/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import junit.framework.Test;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.models.aggregate.AggregateSystem;
import org.eclipse.persistence.testing.models.collections.CollectionsSystem;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.models.inheritance.InheritanceSystem;
import org.eclipse.persistence.testing.models.legacy.LegacySystem;
import org.eclipse.persistence.testing.models.mapping.MappingSystem;
import org.eclipse.persistence.testing.models.multipletable.ProjectSystem;
import org.eclipse.persistence.testing.models.ownership.OwnershipSystem;
import org.eclipse.persistence.testing.tests.employee.EmployeeBasicTestModel;
import org.eclipse.persistence.testing.tests.expressions.ExpressionTestSuite;
import org.eclipse.persistence.testing.tests.feature.EmployeeNativeModeSystem;
import org.eclipse.persistence.testing.tests.feature.OracleNativeSeqInitTest;
import org.eclipse.persistence.testing.tests.inheritance.InheritanceTestModel;

public class NativeModeCreatorTestModel
extends TestModel {
    protected Boolean usesNativeSQL;
    protected Sequence defaultSequence;
    protected Boolean shouldBindAllParameters;
    protected String qualifier;

    public void addForcedRequiredSystems() {
        DatabasePlatform platform = this.getSession().getPlatform();
        this.usesNativeSQL = platform.usesNativeSQL();
        this.defaultSequence = this.getSession().getLogin().getDefaultSequence();
        this.shouldBindAllParameters = platform.shouldBindAllParameters();
        if (platform.isSybase() || platform.isSQLAnywhere() || platform.isOracle() || platform.isSQLServer() || platform.isInformix() || platform.isMySQL() || platform.isDB2() || platform.isTimesTen() || platform.isSymfoware()) {
            platform.setUsesNativeSQL(true);
            this.getSession().getLogin().useNativeSequencing();
            this.getDatabaseSession().getSequencingControl().resetSequencing();
        }
        platform.setShouldBindAllParameters(false);
        this.getExecutor().removeConfigureSystem((TestSystem)new EmployeeSystem());
        this.addForcedRequiredSystem(new EmployeeNativeModeSystem());
        this.getExecutor().removeConfigureSystem((TestSystem)new InheritanceSystem());
        this.addForcedRequiredSystem(new InheritanceSystem());
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new OwnershipSystem());
        this.addRequiredSystem(new LegacySystem());
        this.addRequiredSystem(new ProjectSystem());
        this.addRequiredSystem(new CollectionsSystem());
        this.addRequiredSystem(new MappingSystem());
        this.addRequiredSystem(new AggregateSystem());
    }

    public void addTests() {
        this.addTest((Test)EmployeeBasicTestModel.getReadObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getUpdateObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getInsertObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getReadAllTestSuite());
        this.addTest((Test)new ExpressionTestSuite());
        this.addTest((Test)InheritanceTestModel.getDeleteObjectTestSuite());
        TestSuite seqSuite = new TestSuite();
        seqSuite.setName("EmployeeNativeSeqTestSuite");
        seqSuite.setDescription("This suite tests native sequencing in the employee demo.");
        seqSuite.addTest((Test)new OracleNativeSeqInitTest(false, 0));
        seqSuite.addTest((Test)new OracleNativeSeqInitTest(false, 1));
        seqSuite.addTest((Test)new OracleNativeSeqInitTest(false, 2));
        seqSuite.addTest((Test)new OracleNativeSeqInitTest(false, 3));
        this.addTest((Test)seqSuite);
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        if (this.getSession().getLogin().getPlatform().isOracle()) {
            String oldUser = null;
            try {
                oldUser = this.getAbstractSession().getAccessor().getConnection().getMetaData().getUserName();
            }
            catch (Exception exception) {
                throw new TestErrorException("Meta-data error.", (Throwable)exception);
            }
            this.getExecutor().swapCleanDatabaseSession();
            this.getSession().getLogin().setUserName("scott");
            this.getSession().getLogin().setPassword("tiger");
            this.qualifier = this.getSession().getLogin().getTableQualifier();
            this.getSession().getLogin().setTableQualifier(oldUser);
            this.getDatabaseSession().logout();
            DatabaseSession newDBSession = this.getDatabaseSession();
            new EmployeeNativeModeSystem().addDescriptors(newDBSession);
            new InheritanceSystem().addDescriptors(newDBSession);
            new OwnershipSystem().addDescriptors(newDBSession);
            new LegacySystem().addDescriptors(newDBSession);
            new ProjectSystem().addDescriptors(newDBSession);
            new CollectionsSystem().addDescriptors(newDBSession);
            new MappingSystem().addDescriptors(newDBSession);
            new AggregateSystem().addDescriptors(newDBSession);
            this.getDatabaseSession().login();
            new EmployeeNativeModeSystem().dropTableConstraints(this.getSession());
            new InheritanceSystem().dropTableConstraints(this.getSession());
        }
    }

    public void reset() {
        this.getExecutor().resetSession();
        DatabasePlatform platform = this.getSession().getPlatform();
        if (platform.isSybase() || platform.isSQLAnywhere() || platform.isOracle() || platform.isSQLServer() || platform.isInformix() || platform.isMySQL() || platform.isDB2() || platform.isTimesTen() || platform.isSymfoware()) {
            if (this.usesNativeSQL != null) {
                platform.setUsesNativeSQL(this.usesNativeSQL.booleanValue());
            }
            if (this.defaultSequence != null) {
                this.getSession().getLogin().setDefaultSequence(this.defaultSequence);
                this.getDatabaseSession().getSequencingControl().resetSequencing();
            }
        }
        if (this.shouldBindAllParameters != null) {
            platform.setShouldBindAllParameters(this.shouldBindAllParameters.booleanValue());
        }
        if (this.qualifier != null) {
            this.getSession().getLogin().setTableQualifier(this.qualifier);
        }
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.getExecutor().removeConfigureSystem((TestSystem)new EmployeeSystem());
        this.getExecutor().removeConfigureSystem((TestSystem)new InheritanceSystem());
        this.getDatabaseSession().logout();
        this.getDatabaseSession().login();
    }
}

