/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.inherited;

import java.util.Date;
import javax.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.inherited.Accredidation;
import org.eclipse.persistence.testing.models.jpa.inherited.Alpine;
import org.eclipse.persistence.testing.models.jpa.inherited.Beer;
import org.eclipse.persistence.testing.models.jpa.inherited.BeerConsumer;
import org.eclipse.persistence.testing.models.jpa.inherited.Beverage;
import org.eclipse.persistence.testing.models.jpa.inherited.ExpertBeerConsumer;
import org.eclipse.persistence.testing.models.jpa.inherited.InheritedTableManager;
import org.eclipse.persistence.testing.models.jpa.inherited.SerialNumber;

public class InheritedCallbacksJunitTest
extends JUnitTestCase {
    private static Integer m_Id;

    public InheritedCallbacksJunitTest() {
    }

    public InheritedCallbacksJunitTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("InheritedCallbacksJunitTest");
        suite.addTest((Test)new InheritedCallbacksJunitTest("testSetup"));
        suite.addTest((Test)new InheritedCallbacksJunitTest("testPreAndPostPersistAlpine"));
        suite.addTest((Test)new InheritedCallbacksJunitTest("testPrePersistAlpineOnMerge"));
        suite.addTest((Test)new InheritedCallbacksJunitTest("testPrePersistAlpineAndSerialNumberOnBeerConsumerMerge"));
        suite.addTest((Test)new InheritedCallbacksJunitTest("testPreAndPostPersistBeerConsumer"));
        suite.addTest((Test)new InheritedCallbacksJunitTest("testPreAndPostPersistExpertBeerConsumer"));
        suite.addTest((Test)new InheritedCallbacksJunitTest("testPostLoadOnFind"));
        suite.addTest((Test)new InheritedCallbacksJunitTest("testPostLoadOnRefresh"));
        suite.addTest((Test)new InheritedCallbacksJunitTest("testPreAndPostUpdate"));
        suite.addTest((Test)new InheritedCallbacksJunitTest("testPreAndPostRemove"));
        return suite;
    }

    public void testSetup() {
        new InheritedTableManager().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testPreAndPostPersistAlpine() {
        EntityManager em = this.createEntityManager();
        try {
            int beerPrePersistCount = Beer.BEER_PRE_PERSIST_COUNT;
            int alpinePrePersistCount = Alpine.ALPINE_PRE_PERSIST_COUNT;
            int beveragePostPersistCount = Beverage.BEVERAGE_POST_PERSIST_COUNT;
            int beerPostPersistCount = Beer.BEER_POST_PERSIST_COUNT;
            int alpinePostPersistCount = Alpine.ALPINE_POST_PERSIST_COUNT;
            this.beginTransaction(em);
            SerialNumber serialNumber = new SerialNumber();
            em.persist((Object)serialNumber);
            Alpine alpine = new Alpine(serialNumber);
            alpine.setBestBeforeDate(new Date(2007, 8, 17));
            alpine.setAlcoholContent((Object)5.0);
            em.persist((Object)alpine);
            this.commitTransaction(em);
            this.verifyNotCalled(beerPrePersistCount, Beer.BEER_PRE_PERSIST_COUNT, "celebrate");
            this.verifyCalled(alpinePrePersistCount, Alpine.ALPINE_PRE_PERSIST_COUNT, "celebrate");
            this.verifyNotCalled(beveragePostPersistCount, Beverage.BEVERAGE_POST_PERSIST_COUNT, "celebrateAgain");
            this.verifyCalled(beerPostPersistCount, Beer.BEER_POST_PERSIST_COUNT, "celebrateSomeMore");
            this.verifyCalled(alpinePostPersistCount, Alpine.ALPINE_POST_PERSIST_COUNT, "celebrateAgain");
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testPrePersistAlpineOnMerge() {
        EntityManager em = this.createEntityManager();
        try {
            int beerPrePersistCount = Beer.BEER_PRE_PERSIST_COUNT;
            int alpinePrePersistCount = Alpine.ALPINE_PRE_PERSIST_COUNT;
            this.beginTransaction(em);
            SerialNumber serialNumber = new SerialNumber();
            em.persist((Object)serialNumber);
            Alpine alpine = new Alpine(serialNumber);
            alpine.setBestBeforeDate(new Date(2007, 8, 17));
            alpine.setAlcoholContent((Object)5.0);
            alpine.setClassification(Alpine.Classification.NONE);
            Alpine mergedAlpine = (Alpine)em.merge((Object)alpine);
            this.verifyNotCalled(beerPrePersistCount, Beer.BEER_PRE_PERSIST_COUNT, "PrePersist");
            this.verifyCalled(alpinePrePersistCount, Alpine.ALPINE_PRE_PERSIST_COUNT, "PrePersist");
            InheritedCallbacksJunitTest.assertTrue((String)"The merged alpine classification was not updated from the PrePersist lifecycle method", (mergedAlpine.getClassification() == Alpine.Classification.STRONG ? 1 : 0) != 0);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testPrePersistAlpineAndSerialNumberOnBeerConsumerMerge() {
        EntityManager em = this.createEntityManager();
        try {
            int beerPrePersistCount = Beer.BEER_PRE_PERSIST_COUNT;
            int alpinePrePersistCount = Alpine.ALPINE_PRE_PERSIST_COUNT;
            int serialNumberPrePersistCount = SerialNumber.SERIAL_NUMBER_PRE_PERSIST_COUNT;
            this.beginTransaction(em);
            BeerConsumer beerConsumer = new BeerConsumer();
            beerConsumer.setName("A consumer to delete eventually");
            em.persist((Object)beerConsumer);
            em.clear();
            SerialNumber serialNumber = new SerialNumber();
            Alpine alpine = new Alpine(serialNumber);
            alpine.setBestBeforeDate(new Date(2007, 8, 17));
            alpine.setAlcoholContent((Object)5.0);
            alpine.setClassification(Alpine.Classification.NONE);
            beerConsumer.addAlpineBeerToConsume(alpine);
            BeerConsumer mergedBeerConsumer = (BeerConsumer)em.merge((Object)beerConsumer);
            mergedBeerConsumer.getAlpineBeerToConsume(0).setId((Object)mergedBeerConsumer.getAlpineBeerToConsume(0).getSerialNumber().getNumber());
            this.verifyNotCalled(beerPrePersistCount, Beer.BEER_PRE_PERSIST_COUNT, "PrePersist");
            this.verifyCalled(alpinePrePersistCount, Alpine.ALPINE_PRE_PERSIST_COUNT, "PrePersist");
            this.verifyCalled(serialNumberPrePersistCount, SerialNumber.SERIAL_NUMBER_PRE_PERSIST_COUNT, "PrePersist");
            InheritedCallbacksJunitTest.assertTrue((String)"The merged alpine classification was not updated from the PrePersist lifecycle method", (mergedBeerConsumer.getAlpineBeerToConsume(0).getSerialNumber().getIssueDate() != null ? 1 : 0) != 0);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testPreAndPostPersistBeerConsumer() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            BeerConsumer beerConsumer = new BeerConsumer();
            beerConsumer.setName("A consumer to delete eventually");
            em.persist((Object)beerConsumer);
            m_Id = beerConsumer.getId();
            this.commitTransaction(em);
            this.verifyCalled(0, beerConsumer.pre_persist_count, "PrePersist");
            this.verifyCalled(0, beerConsumer.post_persist_count, "PostPersist");
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testPreAndPostPersistExpertBeerConsumer() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            ExpertBeerConsumer beerConsumer = new ExpertBeerConsumer();
            beerConsumer.setName("An expert consumer to delete eventually");
            Accredidation accredidation = new Accredidation();
            accredidation.setDetails("SuperElite");
            beerConsumer.setAccredidation(accredidation);
            em.persist((Object)beerConsumer);
            this.commitTransaction(em);
            this.verifyNotCalled(0, beerConsumer.pre_persist_count, "PrePersist");
            this.verifyCalled(0, beerConsumer.ebc_pre_persist_count, "PrePersist");
            this.verifyCalled(0, beerConsumer.post_persist_count, "PostPersist");
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testPostLoadOnFind() {
        BeerConsumer beerConsumer = (BeerConsumer)this.createEntityManager().find(BeerConsumer.class, (Object)m_Id);
        this.verifyCalled(0, beerConsumer.post_load_count, "PostLoad");
    }

    public void testPostLoadOnRefresh() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            BeerConsumer beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_Id);
            em.refresh((Object)beerConsumer);
            this.commitTransaction(em);
            this.verifyCalled(0, beerConsumer.post_load_count, "PostLoad");
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testPreAndPostUpdate() {
        EntityManager em = this.createEntityManager();
        try {
            int count2 = 0;
            this.beginTransaction(em);
            BeerConsumer beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_Id);
            int count1 = beerConsumer.pre_update_count;
            beerConsumer.setName("An updated name");
            count2 = beerConsumer.post_update_count;
            this.commitTransaction(em);
            this.verifyCalled(count1, beerConsumer.pre_update_count, "PreUpdate");
            this.verifyCalled(count2, beerConsumer.post_update_count, "PostUpdate");
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testPreAndPostRemove() {
        EntityManager em = this.createEntityManager();
        try {
            int count2 = 0;
            this.beginTransaction(em);
            BeerConsumer beerConsumer = (BeerConsumer)em.find(BeerConsumer.class, (Object)m_Id);
            int count1 = beerConsumer.pre_remove_count;
            em.remove((Object)beerConsumer);
            count2 = beerConsumer.post_remove_count;
            this.commitTransaction(em);
            this.verifyCalled(count1, beerConsumer.pre_remove_count, "PreRemove");
            this.verifyCalled(count2, beerConsumer.post_remove_count, "PostRemove");
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void verifyCalled(int countBefore, int countAfter, String callback) {
        InheritedCallbacksJunitTest.assertFalse((String)("The callback method [" + callback + "] was not called"), (countBefore == countAfter ? 1 : 0) != 0);
        InheritedCallbacksJunitTest.assertTrue((String)("The callback method [" + callback + "] was called more than once"), (countAfter == countBefore + 1 ? 1 : 0) != 0);
    }

    public void verifyNotCalled(int countBefore, int countAfter, String callback) {
        InheritedCallbacksJunitTest.assertTrue((String)("The callback method [" + callback + "] was called."), (countBefore == countAfter ? 1 : 0) != 0);
    }
}

