/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.serializers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.serializers.Serializer;

public class KryoSerializer
implements Serializer {
    Object kryo;
    Constructor outputConstructor;
    Constructor inputConstructor;
    Method writeMethod;
    Method readMethod;
    Method inputCloseMethod;
    Method outputCloseMethod;

    public KryoSerializer() {
        try {
            Class<?> kryoClass = Class.forName("com.esotericsoftware.kryo.Kryo");
            this.kryo = kryoClass.newInstance();
            Class<?> inputClass = Class.forName("com.esotericsoftware.kryo.io.Input");
            this.inputConstructor = inputClass.getConstructor(InputStream.class);
            Class<?> outputClass = Class.forName("com.esotericsoftware.kryo.io.Output");
            this.outputConstructor = outputClass.getConstructor(OutputStream.class);
            this.writeMethod = kryoClass.getMethod("writeClassAndObject", outputClass, Object.class);
            this.readMethod = kryoClass.getMethod("readClassAndObject", inputClass);
            this.inputCloseMethod = inputClass.getMethod("close", new Class[0]);
            this.outputCloseMethod = outputClass.getMethod("close", new Class[0]);
        }
        catch (Exception exception) {
            throw ValidationException.reflectiveExceptionWhileCreatingClassInstance("com.esotericsoftware.kryo.Kryo", exception);
        }
    }

    @Override
    public byte[] serialize(Object object, Session session) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Object output = this.outputConstructor.newInstance(stream);
            this.writeMethod.invoke(this.kryo, output, object);
            this.outputCloseMethod.invoke(output, new Object[0]);
            return stream.toByteArray();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Object deserialize(byte[] bytes, Session session) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            Object input = this.inputConstructor.newInstance(stream);
            Object result = this.readMethod.invoke(this.kryo, input);
            this.inputCloseMethod.invoke(input, new Object[0]);
            return result;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

