/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.FileChooser;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.framework.uitools.UIToolsResourceBundle;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.PrimitiveListTreeModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class ClasspathPanel
extends AbstractPanel {
    private ListValueModel classpathEntriesHolder;
    private ValueModel rootFolderHolder;
    private DefaultClasspathDirectoryHolder defaultClasspathDirectoryHolder;
    private JTree classpathTree;
    private TreeModel classpathModel;
    private TreeSelectionModel classpathSelectionModel;
    private boolean editable;
    private boolean convertToRelativePath;
    private Action addEntryAction;
    private Action browseAction;
    private Action removeAction;
    private Action upAction;
    private Action downAction;
    public static final String MOST_RECENT_CLASSPATH_DIRECTORY_PREFERENCE = "recent classpath directory";

    public ClasspathPanel(ApplicationContext context, ListValueModel classpathEntriesHolder, ValueModel rootFileHolder) {
        this(context, classpathEntriesHolder, rootFileHolder, true, "CLASSPATH_PANEL_TITLE");
    }

    public ClasspathPanel(ApplicationContext context, ListValueModel classpathEntriesHolder, boolean shouldBeEditable) {
        this(context, classpathEntriesHolder, shouldBeEditable, "CLASSPATH_PANEL_TITLE");
    }

    public ClasspathPanel(ApplicationContext context, ListValueModel classpathEntriesHolder, boolean shouldBeEditable, String title) {
        this(context, classpathEntriesHolder, new SimplePropertyValueModel(), shouldBeEditable, title);
    }

    public ClasspathPanel(ApplicationContext context, ListValueModel classpathEntriesHolder, ValueModel rootFileHolder, boolean shouldBeEditable) {
        this(context, classpathEntriesHolder, rootFileHolder, shouldBeEditable, "CLASSPATH_PANEL_TITLE");
    }

    public ClasspathPanel(ApplicationContext context, ListValueModel classpathEntriesHolder, ValueModel rootFileHolder, boolean shouldBeEditable, String title) {
        super(context);
        this.initialize(classpathEntriesHolder, rootFileHolder, shouldBeEditable);
        this.initializeLayout(title);
    }

    private void initialize(ListValueModel classpathEntriesHolder, ValueModel rootFolderHolder, boolean shouldBeEditable) {
        this.classpathEntriesHolder = classpathEntriesHolder;
        this.rootFolderHolder = rootFolderHolder;
        this.defaultClasspathDirectoryHolder = DefaultClasspathDirectoryHolder.NULL_INSTANCE;
        this.classpathModel = this.buildClasspathModel(classpathEntriesHolder);
        this.classpathSelectionModel = this.buildClasspathSelectionModel();
        this.addEntryAction = this.buildAddEntryAction();
        this.browseAction = this.buildBrowseAction();
        this.removeAction = this.buildRemoveAction();
        this.upAction = this.buildUpAction();
        this.downAction = this.buildDownAction();
        this.editable = shouldBeEditable;
        ((DefaultMutableTreeNode)this.classpathModel.getRoot()).setUserObject("");
    }

    protected ApplicationContext initializeContext(ApplicationContext parentContext) {
        return parentContext.buildExpandedResourceRepositoryContext(UIToolsResourceBundle.class);
    }

    private TreeModel buildClasspathModel(ListValueModel model) {
        return new PrimitiveListTreeModel(model){

            @Override
            protected void primitiveChanged(int index, Object newValue) {
                ClasspathPanel.this.replaceEntry(index, newValue);
            }
        };
    }

    private TreeModelListener buildTreeModelListener(final JTree classpathTree) {
        return new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                TreeModel model = (TreeModel)e.getSource();
                ExpandPathRunner runner = new ExpandPathRunner(classpathTree, model.getRoot());
                EventQueue.invokeLater(runner);
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        };
    }

    private TreeSelectionModel buildClasspathSelectionModel() {
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(4);
        return selectionModel;
    }

    private Action buildAddEntryAction() {
        AbstractFrameworkAction action = new AbstractFrameworkAction(this.getApplicationContext()){

            @Override
            protected void initialize() {
                this.setText(this.resourceRepository().getString("ADD_ENTRY_BUTTON_TEXT"));
                this.setMnemonic(this.resourceRepository().getMnemonic("ADD_ENTRY_BUTTON_TEXT"));
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                ClasspathPanel.this.addEntry();
            }
        };
        action.setEnabled(true);
        return action;
    }

    private Action buildBrowseAction() {
        AbstractFrameworkAction action = new AbstractFrameworkAction(this.getApplicationContext()){

            @Override
            protected void initialize() {
                this.initializeTextAndMnemonic("BROWSE_BUTTON_1");
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                ClasspathPanel.this.promptToAddEntries();
            }
        };
        action.setEnabled(true);
        return action;
    }

    private Action buildRemoveAction() {
        AbstractFrameworkAction action = new AbstractFrameworkAction(this.getApplicationContext()){

            @Override
            protected void initialize() {
                this.setText(this.resourceRepository().getString("REMOVE_BUTTON_TEXT"));
                this.setMnemonic(this.resourceRepository().getMnemonic("REMOVE_BUTTON_TEXT"));
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                ClasspathPanel.this.removeEntries();
            }
        };
        action.setEnabled(false);
        return action;
    }

    private Action buildUpAction() {
        AbstractFrameworkAction action = new AbstractFrameworkAction(this.getApplicationContext()){

            @Override
            protected void initialize() {
                this.setText(this.resourceRepository().getString("UP_BUTTON_TEXT"));
                this.setMnemonic(this.resourceRepository().getMnemonic("UP_BUTTON_TEXT"));
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                ClasspathPanel.this.moveSelectedEntriesUp();
            }
        };
        action.setEnabled(false);
        return action;
    }

    private Action buildDownAction() {
        AbstractFrameworkAction action = new AbstractFrameworkAction(this.getApplicationContext()){

            @Override
            protected void initialize() {
                this.setText(this.resourceRepository().getString("DOWN_BUTTON_TEXT"));
                this.setMnemonic(this.resourceRepository().getMnemonic("DOWN_BUTTON_TEXT"));
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                ClasspathPanel.this.moveSelectedEntriesDown();
            }
        };
        action.setEnabled(false);
        return action;
    }

    protected void initializeLayout(String title) {
        GridBagConstraints constraints = new GridBagConstraints();
        this.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder(title), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.classpathTree = this.buildClasspathTree();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 0, 0, 0);
        JScrollPane scrollPane = new JScrollPane(this.classpathTree);
        scrollPane.setMinimumSize(new Dimension(1, 1));
        scrollPane.setPreferredSize(new Dimension(1, 1));
        this.add((Component)scrollPane, constraints);
        AccessibleTitledPanel buttonPanel = new AccessibleTitledPanel(new GridLayout(5, 1, 0, 5));
        buttonPanel.add(new JButton(this.addEntryAction));
        buttonPanel.add(new JButton(this.browseAction));
        buttonPanel.add(new JButton(this.removeAction));
        buttonPanel.add(new JButton(this.upAction));
        buttonPanel.add(new JButton(this.downAction));
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 19;
        constraints.insets = new Insets(1, 5, 0, 0);
        this.add((Component)buttonPanel, constraints);
        this.addAlignRight(buttonPanel);
    }

    private JTree buildClasspathTree() {
        SwingComponentFactory.AccessibleTree classpathTree = new SwingComponentFactory.AccessibleTree(this.classpathModel){

            @Override
            public void cancelEditing() {
                if (this.isEditing()) {
                    TreePath path = this.getEditingPath();
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    String currentEntry = (String)node.getUserObject();
                    super.cancelEditing();
                    if (StringTools.stringIsEmpty((String)currentEntry)) {
                        super.cancelEditing();
                        int rowIndex = this.getRowForPath(path);
                        ClasspathPanel.this.classpathEntriesHolder().removeItems(rowIndex, 1);
                    }
                }
            }
        };
        classpathTree.setSelectionModel(this.classpathSelectionModel);
        classpathTree.addTreeSelectionListener(this.buildClasspathSelectionListener());
        DefaultTreeCellRenderer renderer = this.buildTreeCellRenderer();
        classpathTree.setCellRenderer(renderer);
        classpathTree.setCellEditor(this.buildTreeCellEditor(classpathTree, renderer));
        classpathTree.setRootVisible(false);
        classpathTree.expandPath(new TreePath(this.classpathModel.getRoot()));
        classpathTree.setEditable(this.editable);
        classpathTree.setRowHeight(0);
        classpathTree.setExpandsSelectedPaths(true);
        classpathTree.setDoubleBuffered(true);
        this.classpathModel.addTreeModelListener(this.buildTreeModelListener(classpathTree));
        return classpathTree;
    }

    private TreeSelectionListener buildClasspathSelectionListener() {
        return new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ClasspathPanel.this.classpathSelectionChanged();
            }
        };
    }

    File getRootFolder() {
        return (File)this.rootFolderHolder.getValue();
    }

    private DefaultTreeCellRenderer buildTreeCellRenderer() {
        return new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
                if (leaf) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                    Icon icon = this.buildIconForFile(new File((String)node.getUserObject()));
                    this.setLeafIcon(icon);
                    this.setIcon(icon);
                }
                return this;
            }

            private Icon buildIconForFile(File file) {
                File rootFolder;
                if (!file.isAbsolute() && (rootFolder = ClasspathPanel.this.getRootFolder()) != null) {
                    file = new File(rootFolder, file.getPath());
                }
                return ClasspathPanel.this.resourceRepository().getIcon(this.buildIconKeyForFile(file));
            }

            private String buildIconKeyForFile(File file) {
                if (!file.isAbsolute()) {
                    return "folder";
                }
                if (file.exists()) {
                    return file.isDirectory() ? "folder" : "file";
                }
                return "warning";
            }
        };
    }

    private TreeCellEditor buildTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
        return new DefaultTreeCellEditor(tree, renderer);
    }

    public String getTopicID() {
        return "project.classpath";
    }

    private ListValueModel classpathEntriesHolder() {
        return this.classpathEntriesHolder;
    }

    private int lastEntryIndex() {
        return this.classpathEntriesHolder().size() - 1;
    }

    private void classpathSelectionChanged() {
        this.enableActions();
    }

    private void enableActions() {
        boolean anyEntrySelected = !this.classpathSelectionModel.isSelectionEmpty();
        boolean firstEntrySelected = this.classpathSelectionModel.getMinSelectionRow() == 0;
        boolean lastEntrySelected = this.classpathSelectionModel.getMaxSelectionRow() == this.lastEntryIndex();
        this.removeAction.setEnabled(anyEntrySelected);
        this.upAction.setEnabled(anyEntrySelected && !firstEntrySelected);
        this.downAction.setEnabled(anyEntrySelected && !lastEntrySelected);
    }

    private void removeEntries() {
        this.classpathEntriesHolder().removeItems(this.classpathSelectionModel.getMinSelectionRow(), this.classpathSelectionModel.getSelectionCount());
    }

    private void replaceEntry(int index, Object newEntry) {
        if (!newEntry.equals("")) {
            this.classpathEntriesHolder().replaceItem(index, newEntry);
        }
    }

    private void moveSelectedEntriesUp() {
        Object entry = this.classpathEntriesHolder().removeItem(this.classpathSelectionModel.getMinSelectionRow() - 1);
        this.classpathEntriesHolder().addItem(this.classpathSelectionModel.getMaxSelectionRow() + 1, entry);
        this.enableActions();
    }

    private void moveSelectedEntriesDown() {
        Object entry = this.classpathEntriesHolder().removeItem(this.classpathSelectionModel.getMaxSelectionRow() + 1);
        this.classpathEntriesHolder().addItem(this.classpathSelectionModel.getMinSelectionRow(), entry);
        this.enableActions();
    }

    private void addEntry() {
        if (this.classpathTree.isEditing()) {
            this.classpathTree.cancelEditing();
        }
        TreeNode rootNode = (TreeNode)this.classpathModel.getRoot();
        int index = rootNode.getChildCount();
        int[] selectedRows = this.classpathTree.getSelectionRows();
        if (selectedRows != null && selectedRows.length > 0) {
            index = selectedRows[selectedRows.length - 1];
        }
        this.classpathEntriesHolder().addItems(index, Collections.singletonList(""));
        TreeNode newEntryNode = rootNode.getChildAt(index);
        this.classpathTree.startEditingAtPath(new TreePath(new Object[]{rootNode, newEntryNode}));
    }

    void promptToAddEntries() {
        File[] selectedFiles;
        int len;
        if (this.classpathTree.isEditing()) {
            this.classpathTree.cancelEditing();
        }
        if ((len = (selectedFiles = this.promptToAddFiles()).length) == 0) {
            return;
        }
        ArrayList<String> selectedFileNames = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            selectedFileNames.add(selectedFiles[i].getPath());
        }
        CollectionTools.removeAll(selectedFileNames, (Iterator)((Iterator)this.classpathEntriesHolder().getValue()));
        if (selectedFileNames.isEmpty()) {
            return;
        }
        TreeNode rootNode = (TreeNode)this.classpathModel.getRoot();
        this.classpathSelectionModel.clearSelection();
        int newSelectionStartIndex = this.classpathEntriesHolder().size();
        this.classpathEntriesHolder().addItems(newSelectionStartIndex, selectedFileNames);
        Iterator stream = selectedFileNames.iterator();
        while (stream.hasNext()) {
            this.classpathSelectionModel.addSelectionPath(this.pathFor(rootNode, stream.next()));
        }
        this.enableActions();
    }

    private TreePath pathFor(TreeNode parentNode, Object entry) {
        Enumeration<? extends TreeNode> stream = parentNode.children();
        while (stream.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)stream.nextElement();
            if (!node.getUserObject().equals(entry)) continue;
            return new TreePath(node.getPath());
        }
        throw new IllegalArgumentException("missing entry");
    }

    private File[] promptToAddFiles() {
        JFileChooser fileChooser = this.buildFileChooser();
        int selection = fileChooser.showDialog(SwingUtilities.windowForComponent(this), this.resourceRepository().getString("DIALOG.OK_BUTTON_TEXT"));
        if (selection == 0) {
            this.defaultClasspathDirectoryHolder.setDefaultClasspathDirectory(fileChooser.getCurrentDirectory());
            return fileChooser.getSelectedFiles();
        }
        return new File[0];
    }

    private JFileChooser buildFileChooser() {
        FileChooser fc = new FileChooser(this.getDefaultClasspathDirectory(), this.getRootFolder());
        fc.setFileSelectionMode(2);
        fc.setDialogTitle(this.resourceRepository().getString("ADD_CLASSPATH_ENTRY_DIALOG.TITLE"));
        fc.setMultiSelectionEnabled(true);
        fc.setFileFilter(this.buildFileFilter());
        return fc;
    }

    private FileFilter buildFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName().toLowerCase();
                return name.endsWith(".jar") || name.endsWith(".zip") || file.isDirectory();
            }

            @Override
            public String getDescription() {
                return ClasspathPanel.this.resourceRepository().getString(".jar.zip");
            }
        };
    }

    private File getDefaultClasspathDirectory() {
        return this.defaultClasspathDirectoryHolder.getDefaultClasspathDirectory();
    }

    public void setDefaultClasspathDirectoryHolder(DefaultClasspathDirectoryHolder defaultClasspathDirectoryHolder) {
        this.defaultClasspathDirectoryHolder = defaultClasspathDirectoryHolder;
    }

    public static interface DefaultClasspathDirectoryHolder {
        public static final DefaultClasspathDirectoryHolder NULL_INSTANCE = new DefaultClasspathDirectoryHolder(){

            @Override
            public File getDefaultClasspathDirectory() {
                return null;
            }

            @Override
            public void setDefaultClasspathDirectory(File defaultClasspathDirectory) {
            }

            public String toString() {
                return "NullDefaultClasspathDirectoryHolder";
            }
        };

        public File getDefaultClasspathDirectory();

        public void setDefaultClasspathDirectory(File var1);
    }

    private class ExpandPathRunner
    implements Runnable {
        private final JTree classpathTree;
        private final Object rootNode;

        ExpandPathRunner(JTree classpathTree, Object rootNode) {
            this.classpathTree = classpathTree;
            this.rootNode = rootNode;
        }

        @Override
        public void run() {
            TreePath path = new TreePath(this.rootNode);
            if (!this.classpathTree.isExpanded(path)) {
                this.classpathTree.expandPath(path);
            }
        }
    }
}

