/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateFieldDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.AggregateRuntimeFieldNameGenerator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWUserDefinedQueryKey
extends MWModel
implements MWQueryKey,
MWQueryable,
AggregateRuntimeFieldNameGenerator {
    private volatile String name;
    private MWColumnHandle columnHandle;
    public static final String COLUMN_PROPERTY = "column";

    private MWUserDefinedQueryKey() {
    }

    MWUserDefinedQueryKey(String name, MWRelationalClassDescriptor parent, MWColumn column) {
        this(name, parent);
        this.columnHandle.setColumn(column);
    }

    MWUserDefinedQueryKey(String name, MWRelationalClassDescriptor parent) {
        super(parent);
        this.initialize(name);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.columnHandle = new MWColumnHandle(this, this.buildColumnScrubber());
    }

    private void initialize(String qkName) {
        this.checkName(qkName);
        this.name = qkName;
    }

    protected void checkName(String qkName) {
        if (qkName == null || qkName == "") {
            throw new IllegalArgumentException("MWUserDefinedQueryKey name cannot be null");
        }
        this.getDescriptor().checkQueryKeyName(qkName);
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.columnHandle);
    }

    private MWHandle.NodeReferenceScrubber buildColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWUserDefinedQueryKey.this.setColumn(null);
            }

            public String toString() {
                return "MWUserDefinedQueryKey.buildColumnScrubber()";
            }
        };
    }

    @Override
    public boolean allowsChildren() {
        return false;
    }

    @Override
    public boolean allowsOuterJoin() {
        return this.allowsChildren();
    }

    @Override
    public MWMappingDescriptor getParentDescriptor() {
        return this.getDescriptor();
    }

    @Override
    public List subQueryableElements(Filter queryableFilter) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public MWQueryable subQueryableElementAt(int index, Filter queryableFilter) {
        return null;
    }

    @Override
    public boolean isLeaf(Filter queryableFilter) {
        return true;
    }

    @Override
    public String iconKey() {
        return "queryKey.userDefined";
    }

    @Override
    public boolean usesAnyOf() {
        return false;
    }

    @Override
    public boolean isTraversableForReadAllQueryOrderable() {
        return true;
    }

    @Override
    public boolean isValidForReadAllQueryOrderable() {
        return true;
    }

    @Override
    public boolean isTraversableForBatchReadAttribute() {
        return false;
    }

    @Override
    public boolean isValidForBatchReadAttribute() {
        return false;
    }

    @Override
    public boolean isTraversableForJoinedAttribute() {
        return false;
    }

    @Override
    public boolean isValidForJoinedAttribute() {
        return false;
    }

    @Override
    public boolean isValidForReportQueryAttribute() {
        return true;
    }

    @Override
    public boolean isTraversableForReportQueryAttribute() {
        return true;
    }

    @Override
    public boolean isTraversableForQueryExpression() {
        return true;
    }

    @Override
    public boolean isValidForQueryExpression() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.checkName(name);
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
        if (this.attributeValueHasChanged(old, name)) {
            this.getProject().nodeRenamed(this);
        }
    }

    @Override
    public boolean isAutoGenerated() {
        return false;
    }

    @Override
    public MWRelationalClassDescriptor getDescriptor() {
        return (MWRelationalClassDescriptor)this.getParent();
    }

    @Override
    public MWColumn getColumn() {
        return this.columnHandle.getColumn();
    }

    public void setColumn(MWColumn column) {
        MWColumn old = this.columnHandle.getColumn();
        this.columnHandle.setColumn(column);
        this.firePropertyChanged(COLUMN_PROPERTY, old, column);
    }

    @Override
    public String fieldNameForRuntime() {
        return "QUERY_KEY " + this.getName();
    }

    @Override
    public AggregateFieldDescription fullFieldDescription() {
        return new AggregateFieldDescription(){

            @Override
            public String getMessageKey() {
                return "AGGREGATE_FIELD_DESCRIPTION_FOR_USER_DEFINED_QUERY_KEY";
            }

            @Override
            public Object[] getMessageArguments() {
                return new Object[]{MWUserDefinedQueryKey.this.getName()};
            }
        };
    }

    @Override
    public boolean fieldIsWritten() {
        return false;
    }

    @Override
    public MWDescriptor owningDescriptor() {
        return (MWDescriptor)this.getParent();
    }

    @Override
    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.checkColumns(newProblems);
    }

    private void checkColumns(List currentProblems) {
        if (((MWRelationalDescriptor)((Object)this.getParentDescriptor())).isAggregateDescriptor()) {
            return;
        }
        if (this.getColumn() == null) {
            currentProblems.add(this.buildProblem("0246", this.getName()));
        } else if (!CollectionTools.contains(((MWTableDescriptor)this.getParentDescriptor()).allAssociatedColumns(), (Object)this.getColumn())) {
            currentProblems.add(this.buildProblem("0247", this.getName()));
        }
    }

    @Override
    public String displayString() {
        return this.getName();
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append("field=");
        if (this.getColumn() == null) {
            sb.append("null");
        } else {
            this.getColumn().toString(sb);
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWUserDefinedQueryKey.class);
        descriptor.addDirectMapping("name", "name/text()");
        XMLCompositeObjectMapping columnHandleMapping = new XMLCompositeObjectMapping();
        columnHandleMapping.setAttributeName("columnHandle");
        columnHandleMapping.setGetMethodName("getColumnHandleForTopLink");
        columnHandleMapping.setSetMethodName("setColumnHandleForTopLink");
        columnHandleMapping.setReferenceClass(MWColumnHandle.class);
        columnHandleMapping.setXPath("column-handle");
        descriptor.addMapping((DatabaseMapping)columnHandleMapping);
        return descriptor;
    }

    private MWColumnHandle getColumnHandleForTopLink() {
        return this.columnHandle.getColumn() == null ? null : this.columnHandle;
    }

    private void setColumnHandleForTopLink(MWColumnHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildColumnScrubber();
        this.columnHandle = handle == null ? new MWColumnHandle(this, scrubber) : handle.setScrubber(scrubber);
    }
}

