/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWReturningPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalReturningPolicyInsertFieldReturnOnlyFlag;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWOneToOneMapping;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWRelationalReturningPolicy
extends MWReturningPolicy {
    private Collection updateFieldHandles;
    private MWHandle.NodeReferenceScrubber updateFieldScrubber;

    private MWRelationalReturningPolicy() {
    }

    MWRelationalReturningPolicy(MWRelationalClassDescriptor parent) {
        super(parent);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.updateFieldHandles = new Vector();
    }

    public MWRelationalReturningPolicyInsertFieldReturnOnlyFlag addInsertFieldReadOnlyFlag(MWColumn insertColumn) {
        MWRelationalReturningPolicyInsertFieldReturnOnlyFlag insertFieldReturnOnlyFlag = new MWRelationalReturningPolicyInsertFieldReturnOnlyFlag(this, insertColumn);
        this.addInsertFieldReadOnlyFlag(insertFieldReturnOnlyFlag);
        return insertFieldReturnOnlyFlag;
    }

    private Iterator updateFieldHandles() {
        return new CloneIterator(this.updateFieldHandles){

            @Override
            protected void remove(Object current) {
                MWRelationalReturningPolicy.this.removeUpdateFieldHandle((MWColumnHandle)current);
            }
        };
    }

    void removeUpdateFieldHandle(MWColumnHandle handle) {
        this.updateFieldHandles.remove(handle);
        this.fireItemRemoved("updateFields", handle.getColumn());
    }

    @Override
    public Iterator updateFields() {
        return new TransformationIterator(this.updateFieldHandles()){

            @Override
            protected Object transform(Object next) {
                return ((MWColumnHandle)next).getColumn();
            }
        };
    }

    @Override
    public int updateFieldsSize() {
        return this.updateFieldHandles.size();
    }

    public void addUpdateField(MWColumn updateField) {
        if (CollectionTools.contains(this.updateFields(), (Object)updateField)) {
            throw new IllegalArgumentException(updateField.toString());
        }
        this.updateFieldHandles.add(new MWColumnHandle(this, updateField, this.updateFieldScrubber()));
        this.fireItemAdded("updateFields", updateField);
    }

    @Override
    public void removeUpdateField(MWDataField updateField) {
        this.removeUpdateField((MWColumn)updateField);
    }

    public void removeUpdateField(MWColumn updateField) {
        Iterator stream = this.updateFields();
        while (stream.hasNext()) {
            if (stream.next() != updateField) continue;
            stream.remove();
            return;
        }
        throw new IllegalArgumentException(updateField.toString());
    }

    private MWRelationalClassDescriptor relationalDescriptor() {
        return (MWRelationalClassDescriptor)this.getParent();
    }

    @Override
    protected void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        this.checkPlatformForNativeReturningSupport(problems);
        this.checkUpdateFields(problems);
        this.checkSequenceColumn(problems);
        this.checkOneToOneForeignKey(problems);
    }

    private void checkPlatformForNativeReturningSupport(List newProblems) {
        if (!this.getProject().getDatabase().getDatabasePlatform().supportsNativeReturning()) {
            newProblems.add(this.buildProblem("0347"));
        }
    }

    private void checkUpdateFields(List problems) {
        Iterator stream = this.updateFields();
        while (stream.hasNext()) {
            MWDataField field = (MWDataField)stream.next();
            if (CollectionTools.contains(this.relationalDescriptor().allAssociatedColumns(), (Object)field)) continue;
            problems.add(this.buildProblem("0331", field.fieldName()));
        }
    }

    private void checkSequenceColumn(List newProblems) {
        MWColumn sequenceColumn = ((MWTableDescriptor)this.getOwningDescriptor()).getSequenceNumberColumn();
        if (CollectionTools.contains(this.updateFields(), (Object)sequenceColumn)) {
            newProblems.add(this.buildProblem("0333", sequenceColumn.qualifiedName()));
        }
        if (CollectionTools.contains(this.insertFields(), (Object)sequenceColumn)) {
            newProblems.add(this.buildProblem("0332", sequenceColumn.qualifiedName()));
        }
    }

    private void checkOneToOneForeignKey(List newProblems) {
        Iterator stream = this.getProject().allMappings();
        while (stream.hasNext()) {
            MWOneToOneMapping oneToOneMapping;
            MWMapping mapping = (MWMapping)stream.next();
            if (!mapping.isOneToOneMapping() || (oneToOneMapping = (MWOneToOneMapping)mapping).getReference() == null || !oneToOneMapping.getReference().isForeignKeyReference()) continue;
            Iterator stream2 = oneToOneMapping.getReference().columnPairs();
            while (stream2.hasNext()) {
                MWColumn sourceColumn = ((MWColumnPair)stream2.next()).getSourceColumn();
                if (CollectionTools.contains(this.updateFields(), (Object)sourceColumn)) {
                    newProblems.add(this.buildProblem("0339", sourceColumn.qualifiedName(), oneToOneMapping.getName()));
                }
                if (!CollectionTools.contains(this.insertFields(), (Object)sourceColumn)) continue;
                newProblems.add(this.buildProblem("0338", sourceColumn.qualifiedName(), oneToOneMapping.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Collection collection = this.updateFieldHandles;
        synchronized (collection) {
            children.addAll(this.updateFieldHandles);
        }
    }

    private MWHandle.NodeReferenceScrubber updateFieldScrubber() {
        if (this.updateFieldScrubber == null) {
            this.updateFieldScrubber = this.buildUpdateFieldScrubber();
        }
        return this.updateFieldScrubber;
    }

    private MWHandle.NodeReferenceScrubber buildUpdateFieldScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWRelationalReturningPolicy.this.removeUpdateFieldHandle((MWColumnHandle)handle);
            }

            public String toString() {
                return "MWRelationalReturningPolicy.buildUpdateFieldScrubber()";
            }
        };
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWRelationalReturningPolicy.class);
        XMLCompositeCollectionMapping insertFieldReturnOnlyFlagsMapping = new XMLCompositeCollectionMapping();
        insertFieldReturnOnlyFlagsMapping.setAttributeName("insertFieldReturnOnlyFlags");
        insertFieldReturnOnlyFlagsMapping.setReferenceClass(MWRelationalReturningPolicyInsertFieldReturnOnlyFlag.class);
        insertFieldReturnOnlyFlagsMapping.setGetMethodName("getInsertFieldReturnOnlyFlagsForTopLink");
        insertFieldReturnOnlyFlagsMapping.setSetMethodName("setInsertFieldReturnOnlyFlagsForTopLink");
        insertFieldReturnOnlyFlagsMapping.setXPath("insert-field-read-only-flags/insert-field-read-only-flag");
        descriptor.addMapping((DatabaseMapping)insertFieldReturnOnlyFlagsMapping);
        XMLCompositeCollectionMapping updateFieldHandlesMapping = new XMLCompositeCollectionMapping();
        updateFieldHandlesMapping.setAttributeName("updateFieldHandles");
        updateFieldHandlesMapping.setGetMethodName("getUpdateFieldHandlesForTopLink");
        updateFieldHandlesMapping.setSetMethodName("setUpdateFieldHandlesForTopLink");
        updateFieldHandlesMapping.setReferenceClass(MWColumnHandle.class);
        updateFieldHandlesMapping.setXPath("update-field-handles/column-handle");
        descriptor.addMapping((DatabaseMapping)updateFieldHandlesMapping);
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getUpdateFieldHandlesForTopLink() {
        Collection collection = this.updateFieldHandles;
        synchronized (collection) {
            return new TreeSet(this.updateFieldHandles);
        }
    }

    private void setUpdateFieldHandlesForTopLink(Collection handles) {
        Iterator stream = handles.iterator();
        while (stream.hasNext()) {
            ((MWColumnHandle)stream.next()).setScrubber(this.updateFieldScrubber());
        }
        this.updateFieldHandles = handles;
    }
}

