/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.ConformingTestConfiguration;

public class ScrollableCursorBackwardReadingTest
extends TestCase {
    protected boolean useConforming = false;
    ConformingTestConfiguration configuration = null;
    protected boolean cursorSuccess = false;
    protected Exception caughtException = null;
    Vector readWithNext = null;
    Vector readWithPrevious = null;
    protected boolean TYPE_SCROLL_INSENSITIVE_isSupported;
    protected boolean CONCUR_UPDATABLE_isSupported;

    public ScrollableCursorBackwardReadingTest() {
        this.setDescription("This test verifies that the number of objects read in from the end of a scrollable cursor to the start matches the number of object read in using a normal query");
    }

    public ScrollableCursorBackwardReadingTest(boolean useConforming) {
        this();
        if (useConforming) {
            this.setName("ScrollableCursorBackwardReadingConformingTest");
            this.useConforming = useConforming;
            this.configuration = new ConformingTestConfiguration();
        }
    }

    protected void setup() {
        if (this.getSession().getPlatform().isDB2() || this.getSession().getPlatform().isAccess() || this.getSession().getPlatform().isTimesTen()) {
            throw new TestWarningException("ScrollableCursor is not supported on this platform");
        }
        this.TYPE_SCROLL_INSENSITIVE_isSupported = true;
        this.CONCUR_UPDATABLE_isSupported = true;
        if (this.getSession().getPlatform().isSQLServer()) {
            this.TYPE_SCROLL_INSENSITIVE_isSupported = false;
            this.CONCUR_UPDATABLE_isSupported = false;
        }
        if (this.getSession().getPlatform().isSymfoware()) {
            this.CONCUR_UPDATABLE_isSupported = false;
        }
        this.readWithNext = new Vector();
        this.readWithPrevious = new Vector();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        if (this.configuration != null) {
            this.configuration.setup(this.getSession());
            this.getExecutor().setSession((Session)this.configuration.getUnitOfWork());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        ReadAllQuery query = new ReadAllQuery();
        ScrollableCursor cursor = null;
        try {
            query.setReferenceClass(Employee.class);
            if (this.TYPE_SCROLL_INSENSITIVE_isSupported && this.CONCUR_UPDATABLE_isSupported) {
                query.useScrollableCursor(2);
            } else {
                ScrollableCursorPolicy policy = new ScrollableCursorPolicy();
                if (!this.TYPE_SCROLL_INSENSITIVE_isSupported) {
                    policy.setResultSetType(1005);
                }
                if (!this.CONCUR_UPDATABLE_isSupported) {
                    policy.setResultSetConcurrency(1007);
                }
                policy.setPageSize(2);
                query.useScrollableCursor(policy);
            }
            if (this.configuration != null) {
                ExpressionBuilder builder = new ExpressionBuilder();
                Expression exp = builder.get("salary").greaterThan(50000);
                query.setSelectionCriteria(exp);
                query.conformResultsInUnitOfWork();
            }
            cursor = (ScrollableCursor)this.getSession().executeQuery((DatabaseQuery)query);
            try {
                int totalItems = 0;
                while (cursor.hasNext()) {
                    this.readWithNext.addElement(cursor.next());
                    ++totalItems;
                }
                while (cursor.hasPrevious()) {
                    this.readWithPrevious.addElement(cursor.previous());
                    --totalItems;
                }
                this.cursorSuccess = totalItems == 0;
                int size = this.readWithPrevious.size();
                for (int i = 0; i < this.readWithNext.size(); ++i) {
                    this.cursorSuccess = this.cursorSuccess && this.readWithNext.elementAt(i) == this.readWithPrevious.elementAt(size - 1 - i);
                }
            }
            catch (QueryException ex) {
                this.caughtException = ex;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public void reset() {
        if (this.configuration != null) {
            this.getExecutor().setSession((Session)this.configuration.getUnitOfWork().getParent());
            this.configuration.reset();
        }
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void verify() {
        if (this.caughtException != null) {
            throw new TestErrorException("Cursor navigation caused a QueryException.", (Throwable)this.caughtException);
        }
        if (!this.cursorSuccess) {
            throw new TestErrorException("Cursor navigation failed.  Either next() or previous is not returning the correct result.");
        }
    }
}

