/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.DailyCacheInvalidationPolicy;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.QuerySQLTracker;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.insurance.Address;
import org.eclipse.persistence.testing.models.insurance.HealthPolicy;
import org.eclipse.persistence.testing.models.insurance.Policy;
import org.eclipse.persistence.testing.models.insurance.PolicyHolder;

public class QueryExecutionTimeSetOnBuildObjectTest
extends TransactionalTestCase {
    protected QuerySQLTracker sqlTracker;
    private CacheInvalidationPolicy oldHolderCacheInvalidationPolicy;
    private boolean oldPoliciesShouldBatchRead;
    private boolean oldPoliciesShouldBePrivateOwned;
    private boolean oldPolicyHolderShouldBeBatchRead;
    private boolean oldPolicyHolderShouldBePrivateOwned;
    private int oldPolicyHolderJoining;
    private boolean oldAddressShouldBeBatchRead;
    private boolean oldAddressShouldBePrivateOwned;
    private int oldAddressJoining;

    public QueryExecutionTimeSetOnBuildObjectTest() {
        this.setDescription("Test that no duplicate sql is generated for nested join queries without indirection");
    }

    public void setup() {
        super.setup();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        ClassDescriptor holderDescriptor = this.getSession().getDescriptor(PolicyHolder.class);
        ClassDescriptor policyDescriptor = this.getSession().getDescriptor(Policy.class);
        ClassDescriptor addressDescriptor = this.getSession().getDescriptor(Address.class);
        this.oldHolderCacheInvalidationPolicy = holderDescriptor.getCacheInvalidationPolicy();
        holderDescriptor.setCacheInvalidationPolicy((CacheInvalidationPolicy)new DailyCacheInvalidationPolicy(0, 0, 0, 0));
        OneToManyMapping policyHolderToPoliciesMapping = (OneToManyMapping)holderDescriptor.getMappingForAttributeName("policies");
        this.oldPoliciesShouldBatchRead = policyHolderToPoliciesMapping.shouldUseBatchReading();
        policyHolderToPoliciesMapping.setUsesBatchReading(true);
        this.oldPoliciesShouldBePrivateOwned = policyHolderToPoliciesMapping.isPrivateOwned();
        policyHolderToPoliciesMapping.setIsPrivateOwned(true);
        OneToOneMapping policyToPolicyHolderMapping = (OneToOneMapping)policyDescriptor.getMappingForAttributeName("policyHolder");
        this.oldPolicyHolderShouldBeBatchRead = policyToPolicyHolderMapping.shouldUseBatchReading();
        policyToPolicyHolderMapping.setUsesBatchReading(false);
        this.oldPolicyHolderShouldBePrivateOwned = policyToPolicyHolderMapping.isPrivateOwned();
        policyToPolicyHolderMapping.setIsPrivateOwned(false);
        this.oldPolicyHolderJoining = policyToPolicyHolderMapping.getJoinFetch();
        policyToPolicyHolderMapping.setJoinFetch(0);
        policyToPolicyHolderMapping.getDescriptor().reInitializeJoinedAttributes();
        OneToOneMapping addressToPolicyHolderMapping = (OneToOneMapping)addressDescriptor.getMappingForAttributeName("policyHolder");
        this.oldAddressShouldBeBatchRead = addressToPolicyHolderMapping.shouldUseBatchReading();
        addressToPolicyHolderMapping.setUsesBatchReading(false);
        this.oldAddressJoining = addressToPolicyHolderMapping.getJoinFetch();
        addressToPolicyHolderMapping.setJoinFetch(1);
        addressToPolicyHolderMapping.getDescriptor().reInitializeJoinedAttributes();
        this.oldAddressShouldBePrivateOwned = addressToPolicyHolderMapping.isPrivateOwned();
        addressToPolicyHolderMapping.setIsPrivateOwned(false);
        PolicyHolder holder = new PolicyHolder();
        holder.setFirstName("David");
        holder.setLastName("Minkoff");
        holder.setMale();
        holder.setSsn(515376L);
        holder.setBirthDate(Helper.dateFromString((String)"1979/03/25"));
        holder.setOccupation("Electrician");
        Address address = new Address();
        address.setCity("Calgary");
        address.setCountry("Canada");
        address.setState("AB");
        address.setStreet("Suite 840, 401 - 9th Avenue SW");
        address.setZipCode("T2P3C5");
        HealthPolicy healthPolicy1 = new HealthPolicy();
        healthPolicy1.setPolicyNumber(515377L);
        healthPolicy1.setDescription("policy 1");
        healthPolicy1.setCoverageRate(1.5f);
        healthPolicy1.setMaxCoverage(50000.0f);
        HealthPolicy healthPolicy2 = new HealthPolicy();
        healthPolicy2.setPolicyNumber(515378L);
        healthPolicy2.setDescription("policy 2");
        healthPolicy2.setCoverageRate(1.5f);
        healthPolicy2.setMaxCoverage(50000.0f);
        HealthPolicy healthPolicy3 = new HealthPolicy();
        healthPolicy3.setPolicyNumber(515379L);
        healthPolicy3.setDescription("policy 3");
        healthPolicy3.setCoverageRate(1.5f);
        healthPolicy3.setMaxCoverage(50000.0f);
        holder.setAddress(address);
        holder.addPolicy(healthPolicy1);
        holder.addPolicy(healthPolicy2);
        holder.addPolicy(healthPolicy3);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)holder);
        uow.commit();
        this.sqlTracker = new QuerySQLTracker(this.getSession());
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Expression expression = new ExpressionBuilder().get("zipCode").equal((Object)"T2P3C5");
        uow.readObject(Address.class, expression);
        uow.release();
    }

    public void verify() {
        int expectedNumberOfStatements = 8;
        int actualNumberOfSQLStatements = this.sqlTracker.getSqlStatements().size();
        if (expectedNumberOfStatements != actualNumberOfSQLStatements) {
            throw new TestErrorException("Expected " + expectedNumberOfStatements + " SQL statements - got " + actualNumberOfSQLStatements);
        }
    }

    public void reset() {
        super.reset();
        ClassDescriptor holderDescriptor = this.getSession().getDescriptor(PolicyHolder.class);
        ClassDescriptor policyDescriptor = this.getSession().getDescriptor(Policy.class);
        ClassDescriptor addressDescriptor = this.getSession().getDescriptor(Address.class);
        this.oldHolderCacheInvalidationPolicy = holderDescriptor.getCacheInvalidationPolicy();
        holderDescriptor.setCacheInvalidationPolicy(this.oldHolderCacheInvalidationPolicy);
        OneToManyMapping policiesMapping = (OneToManyMapping)holderDescriptor.getMappingForAttributeName("policies");
        policiesMapping.setUsesBatchReading(this.oldPoliciesShouldBatchRead);
        policiesMapping.setIsPrivateOwned(this.oldPoliciesShouldBePrivateOwned);
        OneToOneMapping policyHolderMapping = (OneToOneMapping)policyDescriptor.getMappingForAttributeName("policyHolder");
        policyHolderMapping.setUsesBatchReading(this.oldPolicyHolderShouldBeBatchRead);
        policyHolderMapping.setIsPrivateOwned(this.oldPolicyHolderShouldBePrivateOwned);
        policyHolderMapping.setJoinFetch(this.oldPolicyHolderJoining);
        policyHolderMapping.getDescriptor().reInitializeJoinedAttributes();
        OneToOneMapping addressToPolicyHolderMapping = (OneToOneMapping)addressDescriptor.getMappingForAttributeName("policyHolder");
        addressToPolicyHolderMapping.setUsesBatchReading(this.oldAddressShouldBeBatchRead);
        addressToPolicyHolderMapping.setJoinFetch(this.oldAddressJoining);
        addressToPolicyHolderMapping.getDescriptor().reInitializeJoinedAttributes();
        addressToPolicyHolderMapping.setIsPrivateOwned(this.oldAddressShouldBePrivateOwned);
        this.sqlTracker.remove();
    }
}

