/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Collections;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkEventTest;

public class CommitUnitOfWorkForcingSQLExceptionTest
extends UnitOfWorkEventTest {
    public static final int MAX_FIRST_NAME_FIELD_LENGTH = 255;

    @Override
    public void setup() {
        super.setup();
        this.setDescription("Test force of SQLException to exercise the rollback exception handling code");
        if (this.getSession().getLogin().getPlatform().isSybase()) {
            throw new TestWarningException("Sybase silently truncates String data to match the field size");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        boolean exceptionThrown;
        block7: {
            exceptionThrown = false;
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            ((UnitOfWorkImpl)uow).setProperties(Collections.emptyMap());
            Employee anEmployee = (Employee)uow.readObject(Employee.class);
            StringBuffer firstName = new StringBuffer("firstName_maxfieldLength_");
            for (int i = 0; i < 355; ++i) {
                firstName.append("0");
            }
            anEmployee.setFirstName(firstName.toString());
            try {
                uow.commit();
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof UnsupportedOperationException) {
                    exceptionThrown = true;
                    CommitUnitOfWorkForcingSQLExceptionTest.fail((String)(cause.getClass() + " Exception was thrown in error instead of expected SQLException."));
                    break block7;
                }
                exceptionThrown = true;
            }
        }
        if (!exceptionThrown) {
            CommitUnitOfWorkForcingSQLExceptionTest.fail((String)"An expected SQLException was not thrown.");
        }
    }
}

