/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import java.io.File;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class SessionsXMLSessionEventListenerTest
extends AutoVerifyTestCase {
    SessionBroker m_sessionBroker;

    public SessionsXMLSessionEventListenerTest() {
        this.setDescription("Test the event listeners set on a session broker and its sessions");
    }

    public void reset() {
        if (this.m_sessionBroker != null && this.m_sessionBroker.isConnected()) {
            this.m_sessionBroker.logout();
            SessionManager.getManager().getSessions().remove(this.m_sessionBroker);
            this.m_sessionBroker = null;
        }
    }

    public void test() {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader("org/eclipse/persistence/testing/models/sessionsxml/XMLSchemaSessionEventListenerSession.xml");
        this.m_sessionBroker = (SessionBroker)SessionManager.getManager().getSession(loader, "SessionBroker", ((Object)((Object)this)).getClass().getClassLoader(), true, true);
    }

    protected void verify() {
        File f1 = new File("SessionBrokerEventListener");
        if (!f1.exists()) {
            throw new TestErrorException("Pre-login event did not fire on the session broker");
        }
        f1.delete();
        File f2 = new File("ServerSessionEventListener");
        if (!f2.exists()) {
            throw new TestErrorException("Pre-login event did not fire on the server session");
        }
        f2.delete();
    }
}

