/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection;

import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

public class CacheBasedValueHolder
extends DatabaseValueHolder {
    protected transient ForeignReferenceMapping mapping;
    protected Object[] references;
    protected boolean shouldAllowInstantiationDeferral = true;

    public CacheBasedValueHolder(Object[] pks, AbstractRecord foreignKeys, AbstractSession session, ForeignReferenceMapping mapping) {
        this.references = pks;
        this.mapping = mapping;
        this.session = session;
        this.row = foreignKeys;
    }

    public Object[] getCachedPKs() {
        return this.references;
    }

    @Override
    protected Object instantiate() throws DatabaseException {
        return this.instantiate(this.session);
    }

    protected Object instantiate(AbstractSession localSession) throws DatabaseException {
        if (this.session == null) {
            throw ValidationException.instantiatingValueholderWithNullSession();
        }
        return this.mapping.valueFromPKList(this.references, this.row, localSession);
    }

    @Override
    public Object instantiateForUnitOfWorkValueHolder(UnitOfWorkValueHolder unitOfWorkValueHolder) {
        return this.instantiate(unitOfWorkValueHolder.getUnitOfWork());
    }

    @Override
    public boolean isPessimisticLockingValueHolder() {
        return false;
    }

    public void setShouldAllowInstantiationDeferral(boolean shouldAllowInstantiationDeferral) {
        this.shouldAllowInstantiationDeferral = shouldAllowInstantiationDeferral;
    }

    @Override
    public boolean shouldAllowInstantiationDeferral() {
        return this.shouldAllowInstantiationDeferral;
    }
}

