/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.internal.weaving.RelationshipInfo;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jaxb.dynamic.DynamicJAXBContextFactory;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.PersistenceProvider;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.jpa.rs.eventlistener.ChangeListener;
import org.eclipse.persistence.jpa.rs.eventlistener.DatabaseEventListenerFactory;
import org.eclipse.persistence.jpa.rs.eventlistener.DescriptorBasedDatabaseEventListener;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.logging.LoggingLocalization;
import org.eclipse.persistence.jpa.rs.util.DynamicXMLMetadataSource;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.JTATransactionWrapper;
import org.eclipse.persistence.jpa.rs.util.LinkAdapter;
import org.eclipse.persistence.jpa.rs.util.LinkMetadataSource;
import org.eclipse.persistence.jpa.rs.util.PreLoginMappingAdapter;
import org.eclipse.persistence.jpa.rs.util.RelationshipLinkAdapter;
import org.eclipse.persistence.jpa.rs.util.ResourceLocalTransactionWrapper;
import org.eclipse.persistence.jpa.rs.util.TransactionWrapper;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.sessions.server.ServerSession;

public class PersistenceContext {
    public DatabaseEventListenerFactory eventListenerFactory = null;
    public static final String CHANGE_NOTIFICATION_LISTENER = "jpars.change-notification-listener";
    public static final String JPARS_CONTEXT = "eclipselink.jpars.context";
    protected String name = null;
    protected EntityManagerFactory emf;
    protected JAXBContext context = null;
    protected URI baseURI = null;
    protected TransactionWrapper transaction = null;

    public void setEventListenerFactory(DatabaseEventListenerFactory eventListenerFactory) {
        this.eventListenerFactory = eventListenerFactory;
    }

    protected PersistenceContext() {
    }

    public PersistenceContext(String emfName, EntityManagerFactoryImpl emf, URI defaultURI) {
        this.emf = emf;
        this.name = emfName;
        this.transaction = this.getJpaSession().hasExternalTransactionController() ? new JTATransactionWrapper() : new ResourceLocalTransactionWrapper();
        try {
            JAXBContext jaxbContext;
            this.context = jaxbContext = this.createDynamicJAXBContext((Server)emf.getServerSession());
        }
        catch (JAXBException jaxbe) {
            JPARSLogger.fine("exception_creating_jaxb_context", new Object[]{emfName, jaxbe.toString()});
            emf.close();
        }
        catch (IOException e) {
            JPARSLogger.fine("exception_creating_jaxb_context", new Object[]{emfName, e.toString()});
            emf.close();
        }
        this.setBaseURI(defaultURI);
    }

    protected void addDynamicXMLMetadataSources(List<Object> metadataSources, Server session) {
        HashSet<String> packages = new HashSet<String>();
        for (Class descriptorClass : session.getDescriptors().keySet()) {
            String packageName = "";
            if (descriptorClass.getName().lastIndexOf(46) > 0) {
                packageName = descriptorClass.getName().substring(0, descriptorClass.getName().lastIndexOf(46));
            }
            if (packages.contains(packageName)) continue;
            packages.add(packageName);
        }
        for (String packageName : packages) {
            metadataSources.add(new DynamicXMLMetadataSource(session, packageName));
        }
    }

    public void create(Map<String, String> tenantId, Object entity) {
        EntityManager em = this.getEmf().createEntityManager(tenantId);
        try {
            this.transaction.beginTransaction(em);
            em.persist(entity);
            this.transaction.commitTransaction(em);
        }
        finally {
            em.close();
        }
    }

    protected JAXBContext createDynamicJAXBContext(Server session) throws JAXBException, IOException {
        JAXBContext jaxbContext = (JAXBContext)session.getProperty(JAXBContext.class.getName());
        if (jaxbContext != null) {
            return jaxbContext;
        }
        Map<String, Object> properties = this.createJAXBProperties(session);
        ClassLoader cl = session.getPlatform().getConversionManager().getLoader();
        jaxbContext = DynamicJAXBContextFactory.createContextFromOXM((ClassLoader)cl, properties);
        session.setProperty(JAXBContext.class.getName(), (Object)jaxbContext);
        return jaxbContext;
    }

    protected EntityManagerFactoryImpl createEntityManagerFactory(PersistenceUnitInfo info, Map<String, ?> properties) {
        PersistenceProvider provider = new PersistenceProvider();
        EntityManagerFactory emf = provider.createContainerEntityManagerFactory(info, properties);
        return (EntityManagerFactoryImpl)emf;
    }

    protected EntityManager createEntityManager(String tenantId) {
        return this.getEmf().createEntityManager();
    }

    protected Map<String, Object> createJAXBProperties(Server session) throws IOException {
        Object passedOXMLocations;
        HashMap<String, Object> properties = new HashMap<String, Object>(1);
        ArrayList<Object> metadataLocations = new ArrayList<Object>();
        this.addDynamicXMLMetadataSources(metadataLocations, session);
        String oxmLocation = (String)this.emf.getProperties().get("eclipselink.jpa-rs.oxm");
        if (oxmLocation != null) {
            metadataLocations.add(oxmLocation);
        }
        if ((passedOXMLocations = this.emf.getProperties().get("eclipselink.oxm.metadata-source")) != null) {
            if (passedOXMLocations instanceof Collection) {
                metadataLocations.addAll((Collection)passedOXMLocations);
            } else {
                metadataLocations.add(passedOXMLocations);
            }
        }
        metadataLocations.add(new LinkMetadataSource());
        properties.put("eclipselink.oxm.metadata-source", metadataLocations);
        properties.put("eclipselink.session-event-listener", (Object)new PreLoginMappingAdapter());
        return properties;
    }

    public void delete(Map<String, String> tenantId, String type, Object id) {
        EntityManager em = this.getEmf().createEntityManager(tenantId);
        try {
            this.transaction.beginTransaction(em);
            Object entity = em.find(this.getClass(type), id);
            if (entity != null) {
                em.remove(entity);
            }
            this.transaction.commitTransaction(em);
        }
        finally {
            em.close();
        }
    }

    public Object find(String entityName, Object id) {
        return this.find(null, entityName, id);
    }

    public Object find(Map<String, String> tenantId, String entityName, Object id) {
        return this.find(tenantId, entityName, id, null);
    }

    public Object find(Map<String, String> tenantId, String entityName, Object id, Map<String, Object> properties) {
        EntityManager em = this.getEmf().createEntityManager(tenantId);
        try {
            Object object = em.find(this.getClass(entityName), id, properties);
            return object;
        }
        finally {
            em.close();
        }
    }

    public Object findAttribute(Map<String, String> tenantId, String entityName, Object id, Map<String, Object> properties, String attribute) {
        EntityManager em = this.getEmf().createEntityManager(tenantId);
        try {
            Object object = em.find(this.getClass(entityName), id, properties);
            ClassDescriptor descriptor = this.getJpaSession().getClassDescriptor(this.getClass(entityName));
            DatabaseMapping mapping = descriptor.getMappingForAttributeName(attribute);
            if (mapping == null) {
                return null;
            }
            Object object2 = mapping.getRealAttributeValueFromAttribute(mapping.getAttributeValueFromObject(object), object, (AbstractSession)this.getJpaSession());
            return object2;
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object updateOrAddAttribute(Map<String, String> tenantId, String entityName, Object id, Map<String, Object> properties, String attribute, Object attributeValue, String partner) {
        EntityManager em = this.getEmf().createEntityManager(tenantId);
        try {
            ClassDescriptor referenceDescriptor;
            ClassDescriptor descriptor = this.getJpaSession().getClassDescriptor(this.getClass(entityName));
            DatabaseMapping mapping = descriptor.getMappingForAttributeName(attribute);
            Object object = null;
            if (mapping == null) {
                return null;
            }
            if (!mapping.isObjectReferenceMapping()) {
                if (!mapping.isCollectionMapping()) return null;
            }
            DatabaseMapping partnerMapping = null;
            if (partner != null && (partnerMapping = (referenceDescriptor = ((ForeignReferenceMapping)mapping).getReferenceDescriptor()).getMappingForAttributeName(partner)) == null) {
                return null;
            }
            this.transaction.beginTransaction(em);
            try {
                object = em.find(this.getClass(entityName), id, properties);
                if (object == null) {
                    return null;
                }
            }
            catch (Exception e) {
                JPARSLogger.fine("exception_while_updating_attribute", new Object[]{entityName, this.getName(), e.toString()});
                this.transaction.rollbackTransaction(em);
                em.close();
                return null;
            }
            {
                attributeValue = em.merge(attributeValue);
                this.setMappingValueInObject(object, attributeValue, mapping, partnerMapping);
                this.transaction.commitTransaction(em);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            em.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object removeAttribute(Map<String, String> tenantId, String entityName, Object id, Map<String, Object> properties, String attribute, Object attributeValue, String partner) {
        EntityManager em = this.getEmf().createEntityManager(tenantId);
        try {
            ClassDescriptor referenceDescriptor;
            Object object = em.find(this.getClass(entityName), id, properties);
            ClassDescriptor descriptor = this.getJpaSession().getClassDescriptor(this.getClass(entityName));
            DatabaseMapping mapping = descriptor.getMappingForAttributeName(attribute);
            if (mapping == null) {
                return null;
            }
            if (!mapping.isObjectReferenceMapping()) {
                if (!mapping.isCollectionMapping()) return null;
            }
            DatabaseMapping partnerMapping = null;
            if (partner != null && (partnerMapping = (referenceDescriptor = ((ForeignReferenceMapping)mapping).getReferenceDescriptor()).getMappingForAttributeName(partner)) == null) {
                return null;
            }
            this.transaction.beginTransaction(em);
            try {
                attributeValue = em.merge(attributeValue);
                this.removeMappingValueFromObject(object, attributeValue, mapping, partnerMapping);
                this.transaction.commitTransaction(em);
            }
            catch (Exception exception) {
                this.transaction.rollbackTransaction(em);
                em.close();
                return null;
            }
            Object object2 = object;
            return object2;
        }
        finally {
            em.close();
        }
    }

    protected void removeMappingValueFromObject(Object object, Object attributeValue, DatabaseMapping mapping, DatabaseMapping partner) {
        boolean removed;
        if (mapping.isObjectReferenceMapping()) {
            Object currentValue = mapping.getRealAttributeValueFromObject(object, (AbstractSession)this.getJpaSession());
            if (currentValue.equals(attributeValue)) {
                ((ObjectReferenceMapping)mapping).getIndirectionPolicy().setRealAttributeValueInObject(object, null, true);
                if (partner != null) {
                    this.removeMappingValueFromObject(attributeValue, object, partner, null);
                }
            }
        } else if (mapping.isCollectionMapping() && (removed = ((Collection)mapping.getRealAttributeValueFromObject(object, (AbstractSession)this.getJpaSession())).remove(attributeValue)) && partner != null) {
            this.removeMappingValueFromObject(attributeValue, object, partner, null);
        }
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public Class<?> getClass(String entityName) {
        ClassDescriptor descriptor = this.getDescriptor(entityName);
        if (descriptor == null) {
            return null;
        }
        return descriptor.getJavaClass();
    }

    public ServerSession getJpaSession() {
        return (ServerSession)JpaHelper.getServerSession((EntityManagerFactory)this.emf);
    }

    public ClassDescriptor getDescriptor(String entityName) {
        ServerSession session = this.getJpaSession();
        ClassDescriptor descriptor = session.getDescriptorForAlias(entityName);
        if (descriptor == null) {
            for (Object ajaxBSession : this.getJAXBContext().getXMLContext().getSessions()) {
                descriptor = ((Session)ajaxBSession).getClassDescriptorForAlias(entityName);
                if (descriptor != null) break;
            }
        }
        return descriptor;
    }

    public ClassDescriptor getDescriptorForClass(Class clazz) {
        ServerSession session = this.getJpaSession();
        ClassDescriptor descriptor = session.getDescriptor(clazz);
        if (descriptor == null) {
            for (Object ajaxBSession : this.getJAXBContext().getXMLContext().getSessions()) {
                descriptor = ((Session)ajaxBSession).getClassDescriptor(clazz);
                if (descriptor != null) break;
            }
        }
        return descriptor;
    }

    public EntityManagerFactory getEmf() {
        return this.emf;
    }

    public JAXBContext getJAXBContext() {
        return this.context;
    }

    public String getName() {
        return this.name;
    }

    public Object merge(Map<String, String> tenantId, Object entity) {
        EntityManager em = this.getEmf().createEntityManager(tenantId);
        ArrayList<Object> mergedEntity = null;
        try {
            this.transaction.beginTransaction(em);
            if (entity instanceof List) {
                ArrayList<Object> mergeList = new ArrayList<Object>();
                for (Object o : (List)entity) {
                    mergeList.add(em.merge(o));
                }
                mergedEntity = mergeList;
            } else {
                mergedEntity = em.merge(entity);
            }
            this.transaction.commitTransaction(em);
            ArrayList<Object> arrayList = mergedEntity;
            return arrayList;
        }
        finally {
            em.close();
        }
    }

    public DynamicEntity newEntity(String type) {
        return this.newEntity(null, type);
    }

    public DynamicEntity newEntity(Map<String, String> tenantId, String type) {
        JPADynamicHelper helper = new JPADynamicHelper(this.getEmf());
        DynamicEntity entity = null;
        try {
            entity = helper.newDynamicEntity(type);
        }
        catch (IllegalArgumentException e) {
            DynamicType jaxbType;
            ClassDescriptor descriptor = this.getDescriptor(type);
            if (descriptor != null && (jaxbType = (DynamicType)descriptor.getProperty("ENTITY_TYPE")) != null) {
                return jaxbType.newDynamicEntity();
            }
            JPARSLogger.fine("exception_thrown_while_creating_dynamic_entity", new Object[]{type, e.toString()});
            throw e;
        }
        return entity;
    }

    public Object query(Map<String, String> tenantId, String name, Map<?, ?> parameters) {
        return this.query(tenantId, name, parameters, null, false, false);
    }

    public Object query(Map<String, String> tenantId, String name, Map<?, ?> parameters, Map<String, ?> hints, boolean returnSingleResult, boolean executeUpdate) {
        EntityManager em = this.getEmf().createEntityManager(tenantId);
        try {
            Query query = em.createNamedQuery(name);
            DatabaseQuery dbQuery = ((EJBQueryImpl)query).getDatabaseQuery();
            if (parameters != null) {
                for (String key : parameters.keySet()) {
                    Class parameterClass = null;
                    int index = dbQuery.getArguments().indexOf(key);
                    if (index >= 0) {
                        parameterClass = (Class)dbQuery.getArgumentTypes().get(index);
                    }
                    Object parameter = parameters.get(key);
                    if (parameterClass != null) {
                        parameter = ConversionManager.getDefaultManager().convertObject(parameter, parameterClass);
                    }
                    query.setParameter(key, parameter);
                }
            }
            if (hints != null) {
                for (String key : hints.keySet()) {
                    query.setHint(key, hints.get(key));
                }
            }
            if (executeUpdate) {
                this.transaction.beginTransaction(em);
                Integer result = query.executeUpdate();
                this.transaction.commitTransaction(em);
                Integer n = result;
                return n;
            }
            if (returnSingleResult) {
                Object object = query.getSingleResult();
                return object;
            }
            List list = query.getResultList();
            return list;
        }
        finally {
            em.close();
        }
    }

    public void remove(ChangeListener listener) {
        DescriptorBasedDatabaseEventListener changeListener = (DescriptorBasedDatabaseEventListener)this.getJpaSession().getProperty(CHANGE_NOTIFICATION_LISTENER);
        if (changeListener != null) {
            changeListener.removeChangeListener(listener);
        }
    }

    public void setBaseURI(URI baseURI) {
        this.baseURI = baseURI;
    }

    protected void setMappingValueInObject(Object object, Object attributeValue, DatabaseMapping mapping, DatabaseMapping partner) {
        if (mapping.isObjectReferenceMapping()) {
            ((ObjectReferenceMapping)mapping).getIndirectionPolicy().setRealAttributeValueInObject(object, attributeValue, true);
            if (partner != null) {
                this.setMappingValueInObject(attributeValue, object, partner, null);
            }
        } else if (mapping.isCollectionMapping()) {
            ((Collection)mapping.getAttributeValueFromObject(object)).add(attributeValue);
            if (partner != null) {
                this.setMappingValueInObject(attributeValue, object, partner, null);
            }
        }
    }

    public void stop() {
        this.emf.close();
        this.emf = null;
        this.context = null;
    }

    public String toString() {
        return "Application(" + this.getName() + ")::" + System.identityHashCode(this);
    }

    public Object unmarshalEntity(String type, MediaType acceptedMedia, InputStream in) throws JAXBException {
        return this.unmarshalEntity(this.getClass(type), acceptedMedia, in);
    }

    public Object unmarshalEntity(Class type, MediaType acceptedMedia, InputStream in) throws JAXBException {
        JAXBUnmarshaller unmarshaller = this.getJAXBContext().createUnmarshaller();
        unmarshaller.setProperty("eclipselink.json.include-root", (Object)Boolean.FALSE);
        unmarshaller.setProperty("eclipselink.media-type", (Object)acceptedMedia.toString());
        unmarshaller.setAdapter((XmlAdapter)new LinkAdapter(this.getBaseURI().toString(), this));
        JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(in), type);
        if (element.getValue() instanceof List) {
            for (Object object : (List)element.getValue()) {
                this.wrap(object);
            }
            return element.getValue();
        }
        this.wrap(element.getValue());
        return element.getValue();
    }

    protected Object wrap(Object entity) {
        ClassDescriptor descriptor = this.getJpaSession().getDescriptor(entity);
        if (entity instanceof FetchGroupTracker && entity instanceof PersistenceWeavedRest) {
            FetchGroup fetchGroup = new FetchGroup();
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                if (mapping.isForeignReferenceMapping() && !mapping.isPrivateOwned() && this.isRelationshipRepresentedInRelationshipInfo(mapping.getAttributeName(), (PersistenceWeavedRest)entity)) continue;
                fetchGroup.addAttribute(mapping.getAttributeName());
            }
            new FetchGroupManager().setObjectFetchGroup(entity, fetchGroup, null);
        } else if (descriptor.hasRelationships()) {
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                if (!this.isRelationshipRepresentedInRelationshipInfo(mapping.getAttributeName(), (PersistenceWeavedRest)entity)) continue;
                throw new JPARSException(LoggingLocalization.buildMessage("weaving_required_for_relationships", new Object[0]));
            }
        }
        return entity;
    }

    public void marshallEntity(Object object, MediaType mediaType, OutputStream output) throws JAXBException {
        this.marshallEntity(object, mediaType, output, true);
    }

    public void marshallEntity(Object object, MediaType mediaType, OutputStream output, boolean sendRelationships) throws JAXBException {
        block8: {
            if (sendRelationships) {
                this.preMarshallEntity(object);
            }
            JAXBMarshaller marshaller = this.getJAXBContext().createMarshaller();
            marshaller.setProperty("eclipselink.media-type", (Object)mediaType.toString());
            marshaller.setProperty("eclipselink.json.include-root", (Object)false);
            marshaller.setAdapter((XmlAdapter)new LinkAdapter(this.getBaseURI().toString(), this));
            marshaller.setAdapter((XmlAdapter)new RelationshipLinkAdapter(this.getBaseURI().toString(), this));
            marshaller.setListener(new Marshaller.Listener(){

                public void beforeMarshal(Object source) {
                    if (source instanceof DynamicEntity) {
                        DynamicEntityImpl sourceImpl = (DynamicEntityImpl)source;
                        PropertyChangeListener listener = sourceImpl._persistence_getPropertyChangeListener();
                        sourceImpl._persistence_setPropertyChangeListener(null);
                        ((DynamicEntity)source).set("self", source);
                        sourceImpl._persistence_setPropertyChangeListener(listener);
                    }
                }
            });
            if (mediaType == MediaType.APPLICATION_XML_TYPE && object instanceof List) {
                marshaller.setProperty("jaxb.fragment", (Object)true);
                XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
                XMLStreamWriter writer = null;
                try {
                    try {
                        writer = outputFactory.createXMLStreamWriter(output);
                        writer.writeStartDocument();
                        writer.writeStartElement("List");
                        for (Object o : (List)object) {
                            marshaller.marshal(o, writer);
                        }
                        writer.writeEndDocument();
                        break block8;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    this.postMarshallEntity(object);
                }
            }
            marshaller.marshal(object, output);
            this.postMarshallEntity(object);
        }
    }

    protected void preMarshallEntity(Object object) {
        if (object instanceof List) {
            Iterator i = ((List)object).iterator();
            while (i.hasNext()) {
                this.preMarshallIndividualEntity(i.next());
            }
        } else {
            this.preMarshallIndividualEntity(object);
        }
    }

    protected void preMarshallIndividualEntity(Object entity) {
        ClassDescriptor descriptor;
        if (entity instanceof PersistenceWeavedRest && (descriptor = this.getJpaSession().getClassDescriptor(entity.getClass())) != null) {
            ((PersistenceWeavedRest)entity)._persistence_setRelationships(new ArrayList());
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                ForeignReferenceMapping frMapping;
                if (!mapping.isForeignReferenceMapping() || (frMapping = (ForeignReferenceMapping)mapping).isPrivateOwned()) continue;
                RelationshipInfo info = new RelationshipInfo();
                info.setAttributeName(frMapping.getAttributeName());
                info.setOwningEntity(entity);
                info.setOwningEntityAlias(descriptor.getAlias());
                info.setPersistencePrimaryKey(descriptor.getObjectBuilder().extractPrimaryKeyFromObject(entity, (AbstractSession)this.getJpaSession()));
                ((PersistenceWeavedRest)entity)._persistence_getRelationships().add(info);
            }
        }
    }

    protected void postMarshallEntity(Object object) {
        if (object instanceof List) {
            for (Object entity : (List)object) {
                if (!(entity instanceof PersistenceWeavedRest)) continue;
                ((PersistenceWeavedRest)entity)._persistence_setRelationships(new ArrayList());
            }
        } else if (object instanceof PersistenceWeavedRest) {
            ((PersistenceWeavedRest)object)._persistence_setRelationships(new ArrayList());
        }
    }

    private boolean isRelationshipRepresentedInRelationshipInfo(String relationship, PersistenceWeavedRest object) {
        for (RelationshipInfo info : object._persistence_getRelationships()) {
            if (!info.getAttributeName().equals(relationship)) continue;
            return true;
        }
        return false;
    }
}

