/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.handles;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWNode;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.QName;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWXmlProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchemaRepository;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWNamedSchemaComponentHandle
extends MWHandle {
    private volatile MWNamedSchemaComponent component;
    private volatile String schemaName;
    private List qNamePath;

    private MWNamedSchemaComponentHandle() {
    }

    public MWNamedSchemaComponentHandle(MWNode parent, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
    }

    public MWNamedSchemaComponentHandle(MWNode parent, MWNamedSchemaComponent component, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
        this.component = component;
    }

    private MWXmlSchemaRepository getSchemaRepository() {
        return ((MWXmlProject)this.getProject()).getSchemaRepository();
    }

    public MWNamedSchemaComponent getComponent() {
        return this.component;
    }

    public void setComponent(MWNamedSchemaComponent component) {
        this.component = component;
    }

    @Override
    protected Node node() {
        return this.getComponent();
    }

    public MWNamedSchemaComponentHandle setScrubber(MWHandle.NodeReferenceScrubber scrubber) {
        this.setScrubberInternal(scrubber);
        return this;
    }

    @Override
    public void resolveMetadataHandles() {
        MWXmlSchema schema;
        super.resolveMetadataHandles();
        if (this.schemaName != null && !this.qNamePath.isEmpty() && (schema = this.getSchemaRepository().getSchema(this.schemaName)) != null) {
            Iterator stream = this.qNamePath.iterator();
            QName qName = (QName)stream.next();
            MWNamedSchemaComponent temp = schema.component(qName);
            while (stream.hasNext()) {
                qName = (QName)stream.next();
                temp = temp.nestedNamedComponent(qName);
            }
            this.component = temp;
        }
        this.schemaName = null;
        this.qNamePath = null;
    }

    public int compareTo(Object o) {
        return this.component.compareTo(((MWNamedSchemaComponentHandle)o).component);
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append(this.component.getName());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWNamedSchemaComponentHandle.class);
        descriptor.addDirectMapping("schemaName", "getSchemaNameForTopLink", "setSchemaNameForTopLink", "schema/text()");
        XMLCompositeCollectionMapping qNamePathMapping = new XMLCompositeCollectionMapping();
        qNamePathMapping.setAttributeName("qNamePath");
        qNamePathMapping.setReferenceClass(QName.class);
        qNamePathMapping.setGetMethodName("getQNamePathForTopLink");
        qNamePathMapping.setSetMethodName("setQNamePathForTopLink");
        qNamePathMapping.setXPath("qname-path/qname");
        descriptor.addMapping((DatabaseMapping)qNamePathMapping);
        return descriptor;
    }

    private String getSchemaNameForTopLink() {
        return this.component == null ? null : this.component.getSchema().getName();
    }

    private void setSchemaNameForTopLink(String schemaName) {
        this.schemaName = schemaName;
    }

    private List getQNamePathForTopLink() {
        ArrayList<QName> path = new ArrayList<QName>();
        for (MWNamedSchemaComponent temp = this.component; temp != null; temp = temp.parentNamedComponent()) {
            path.add(0, new QName(temp));
        }
        return path;
    }

    private void setQNamePathForTopLink(List path) {
        this.qNamePath = path;
    }
}

