/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.swing.CompositeIcon;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;

public class TriStateCheckBox
extends JCheckBox {
    private Icon checkIcon;
    public static TriStateBoolean PARTIALLY_SELECTED = TriStateBoolean.UNDEFINED;
    public static TriStateBoolean SELECTED = TriStateBoolean.TRUE;
    public static TriStateBoolean UNSELECTED = TriStateBoolean.FALSE;

    public TriStateCheckBox() {
        this((String)null);
    }

    public TriStateCheckBox(String text) {
        this(text, UNSELECTED);
    }

    public TriStateCheckBox(String text, Icon icon, TriStateBoolean selectedState) {
        super(text, icon);
        this.initialize(selectedState);
    }

    public TriStateCheckBox(String text, TriStateBoolean selectedState) {
        this(text, null, selectedState);
    }

    public TriStateBoolean getState() {
        return this.getTriStateModel().getState();
    }

    public TriStateButtonModel getTriStateModel() {
        return (TriStateButtonModel)super.getModel();
    }

    protected void initialize(TriStateBoolean selectedState) {
        this.setOpaque(false);
        this.setModel(new TriStateButtonModel(this.getModel()));
        this.setState(selectedState);
    }

    public boolean isPartiallySelected() {
        return this.getTriStateModel().isPartiallySelected();
    }

    @Override
    public void setIcon(Icon icon) {
        this.setSecondaryIcon(icon);
    }

    public void setSecondaryIcon(Icon icon) {
        if (icon == null) {
            super.setIcon(this.checkIcon);
        } else {
            super.setIcon(new CompositeIcon(this.checkIcon, icon));
        }
    }

    @Override
    public void setSelected(boolean selected) {
        this.setState(selected ? SELECTED : UNSELECTED);
    }

    public void setState(TriStateBoolean state) {
        this.getTriStateModel().setState(state);
    }

    public static class TriStateButtonModel
    implements ButtonModel {
        private final ButtonModel delegate;
        private TriStateBoolean selectionState;

        public TriStateButtonModel(ButtonModel delegate) {
            this.delegate = delegate;
            this.selectionState = TriStateBoolean.valueOf((boolean)delegate.isSelected());
        }

        @Override
        public void addActionListener(ActionListener listener) {
            this.delegate.addActionListener(listener);
        }

        @Override
        public void addChangeListener(ChangeListener listener) {
            this.delegate.addChangeListener(listener);
        }

        @Override
        public void addItemListener(ItemListener listener) {
            this.delegate.addItemListener(listener);
        }

        @Override
        public String getActionCommand() {
            return this.delegate.getActionCommand();
        }

        protected final ButtonModel getDelegate() {
            return this.delegate;
        }

        @Override
        public int getMnemonic() {
            return this.delegate.getMnemonic();
        }

        @Override
        public Object[] getSelectedObjects() {
            return this.delegate.getSelectedObjects();
        }

        protected TriStateBoolean getState() {
            return this.selectionState;
        }

        @Override
        public boolean isArmed() {
            return this.delegate.isArmed();
        }

        @Override
        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        public boolean isPartiallySelected() {
            return this.getState() == PARTIALLY_SELECTED;
        }

        @Override
        public boolean isPressed() {
            return this.delegate.isPressed();
        }

        @Override
        public boolean isRollover() {
            return this.delegate.isRollover();
        }

        @Override
        public boolean isSelected() {
            return this.delegate.isSelected();
        }

        protected void nextState() {
            TriStateBoolean current = this.getState();
            if (current == UNSELECTED) {
                this.setState(SELECTED);
            } else if (current == SELECTED) {
                this.setState(PARTIALLY_SELECTED);
            } else if (current == PARTIALLY_SELECTED) {
                this.setState(UNSELECTED);
            }
        }

        @Override
        public void removeActionListener(ActionListener listener) {
            this.delegate.removeActionListener(listener);
        }

        @Override
        public void removeChangeListener(ChangeListener listener) {
            this.delegate.removeChangeListener(listener);
        }

        @Override
        public void removeItemListener(ItemListener listener) {
            this.delegate.removeItemListener(listener);
        }

        @Override
        public void setActionCommand(String actionCommand) {
            this.delegate.setActionCommand(actionCommand);
        }

        @Override
        public void setArmed(boolean armed) {
            this.delegate.setArmed(armed);
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.delegate.setEnabled(enabled);
        }

        @Override
        public void setGroup(ButtonGroup group) {
            this.delegate.setGroup(group);
        }

        @Override
        public void setMnemonic(int mnemonic) {
            this.delegate.setMnemonic(mnemonic);
        }

        @Override
        public void setPressed(boolean pressed) {
            if (this.isPressed() != pressed && this.isEnabled()) {
                if (!pressed && this.isArmed()) {
                    this.nextState();
                }
                boolean selected = this.isSelected();
                this.delegate.setPressed(pressed);
                this.delegate.setSelected(selected);
            }
        }

        @Override
        public void setRollover(boolean rollover) {
            this.delegate.setRollover(rollover);
        }

        @Override
        public void setSelected(boolean selected) {
            this.delegate.setSelected(selected);
        }

        protected void setState(TriStateBoolean selectionState) {
            if (selectionState == null) {
                selectionState = PARTIALLY_SELECTED;
            }
            this.selectionState = selectionState;
            if (selectionState == PARTIALLY_SELECTED) {
                this.delegate.setSelected(false);
            } else {
                this.delegate.setSelected(selectionState.booleanValue());
            }
        }
    }
}

