/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.sourcegen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.persistence.internal.codegen.ClassDefinition;
import org.eclipse.persistence.internal.codegen.CodeGenerator;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.sourcegen.BasicDescriptorClassCodeGenPolicy;

public final class SourceCodeGenerator {
    private ApplicationContext context;
    private MWProject project;
    private Collection descriptors;
    private File sourceRootDirectory;
    private boolean overwriteFiles;
    private boolean continueGenerating;
    private boolean anyFileWritten;
    private Collection fileAlreadyExistsListeners;
    private Collection continuableExceptionListeners;

    public SourceCodeGenerator(ApplicationContext context) {
        this.context = context;
        this.fileAlreadyExistsListeners = new Vector();
        this.continuableExceptionListeners = new Vector();
        this.continueGenerating = true;
    }

    private ApplicationContext getApplicationContext() {
        return this.context;
    }

    public boolean shouldOverwriteFiles() {
        return this.overwriteFiles;
    }

    public void setOverwriteFiles(boolean overwriteFiles) {
        this.overwriteFiles = overwriteFiles;
    }

    public void generateSourceCode(MWProject project, Collection descriptors) {
        this.generateSourceCode(project, descriptors, null);
    }

    public void generateSourceCode(MWProject project, Collection descriptors, File sourceRootDirectory) {
        this.project = project;
        this.descriptors = descriptors;
        this.sourceRootDirectory = sourceRootDirectory;
        if (!this.overwriteFiles) {
            this.checkForExistingFiles();
        }
        Iterator it = descriptors.iterator();
        while (it.hasNext()) {
            this.generateSourceCode((MWDescriptor)it.next());
        }
    }

    private void generateSourceCode(MWDescriptor descriptor) {
        this.writeClassDefinition(new BasicDescriptorClassCodeGenPolicy(descriptor, this.getApplicationContext()).classDefinition());
    }

    public void checkForExistingFiles() {
        MWDescriptor descriptor;
        File existingFile = null;
        Iterator iter = this.descriptors.iterator();
        while (iter.hasNext() && (existingFile = this.doesFileExist(descriptor = (MWDescriptor)iter.next())) == null) {
        }
        if (existingFile != null) {
            this.fireFileAlreadyExistsEvent(existingFile);
        }
    }

    private File doesFileExist(MWDescriptor descriptor) {
        return this.doesFileExist(new BasicDescriptorClassCodeGenPolicy(descriptor, this.getApplicationContext()).classDefinition());
    }

    private File doesFileExist(ClassDefinition classDef) {
        String writeDirectory;
        File javaFile;
        if (!this.continueGenerating) {
            return null;
        }
        if (classDef == null) {
            return null;
        }
        File sourceRootDirectory = this.sourceRootDirectory;
        if (sourceRootDirectory == null) {
            sourceRootDirectory = this.project.absoluteModelSourceDirectory();
        }
        if ((javaFile = new File(writeDirectory = this.buildDirectory(classDef.getPackageName(), sourceRootDirectory), classDef.getName() + ".java")).exists()) {
            return javaFile;
        }
        return null;
    }

    public void writeClassDefinition(ClassDefinition classDef) {
        if (!this.continueGenerating) {
            return;
        }
        if (classDef == null) {
            return;
        }
        File sourceRootDirectory = this.sourceRootDirectory;
        if (sourceRootDirectory == null) {
            sourceRootDirectory = this.project.absoluteModelSourceDirectory();
        }
        String writeDirectory = this.buildDirectory(classDef.getPackageName(), sourceRootDirectory);
        File javaFile = new File(writeDirectory, classDef.getName() + ".java");
        CodeGenerator codeGenerator = new CodeGenerator();
        try {
            FileOutputStream stream = new FileOutputStream(javaFile);
            codeGenerator.setOutput((Writer)new OutputStreamWriter((OutputStream)stream, "utf-8"));
        }
        catch (IOException ioe) {
            this.fireContinuableExceptionEvent(ioe);
            return;
        }
        classDef.write(codeGenerator);
        this.anyFileWritten = true;
        try {
            codeGenerator.getOutput().flush();
            codeGenerator.getOutput().close();
        }
        catch (IOException ioe) {
            this.fireContinuableExceptionEvent(ioe);
            return;
        }
    }

    public void removeFileAlreadyExistsListener(FileAlreadyExistsListener listener) {
        this.fileAlreadyExistsListeners.remove(listener);
    }

    private String buildDirectory(String packageName, File rootDirectory) {
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        File currentDirectory = rootDirectory;
        currentDirectory.mkdir();
        while (tokenizer.hasMoreTokens()) {
            currentDirectory = new File(currentDirectory.getPath() + File.separator + tokenizer.nextToken());
            currentDirectory.mkdir();
        }
        return currentDirectory.getPath();
    }

    public void addContinuableExceptionListener(ContinuableExceptionListener listener) {
        this.continuableExceptionListeners.add(listener);
    }

    private void fireContinuableExceptionEvent(Exception exception) {
        Iterator listeners = this.continuableExceptionListeners.iterator();
        while (listeners.hasNext()) {
            this.continueGenerating &= ((ContinuableExceptionListener)listeners.next()).continueOnException(new ContinuableExceptionEvent(this, exception));
        }
    }

    public void addFileAlreadyExistsListener(FileAlreadyExistsListener listener) {
        this.fileAlreadyExistsListeners.add(listener);
    }

    private void fireFileAlreadyExistsEvent(File file) {
        Iterator listeners = this.fileAlreadyExistsListeners.iterator();
        while (listeners.hasNext()) {
            this.continueGenerating &= ((FileAlreadyExistsListener)listeners.next()).fileAlreadyExists(this.project, new FileAlreadyExistsEvent(this, file));
        }
    }

    public boolean isAnyFileWritten() {
        return this.anyFileWritten;
    }

    public static interface FileAlreadyExistsListener
    extends EventListener {
        public boolean fileAlreadyExists(MWProject var1, FileAlreadyExistsEvent var2);
    }

    public class FileAlreadyExistsEvent
    extends EventObject {
        private File file;

        protected FileAlreadyExistsEvent(Object source, File file) {
            super(source);
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }

    public static interface ContinuableExceptionListener
    extends EventListener {
        public boolean continueOnException(ContinuableExceptionEvent var1);
    }

    public class ContinuableExceptionEvent
    extends EventObject {
        private Exception exception;

        protected ContinuableExceptionEvent(Object source, Exception exception) {
            super(source);
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

