/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;

public abstract class AbstractEnablableFrameworkAction
extends AbstractFrameworkAction {
    protected ApplicationNode[] selectedNodes;
    private PropertyChangeListener enabledStateListener;
    protected static final String[] DEFAULT_ENABLED_PROPERTY_NAMES = new String[0];

    protected AbstractEnablableFrameworkAction(WorkbenchContext context) {
        super(context);
    }

    protected void updateEnabledState() {
        for (int index = 0; index < this.selectedNodes.length; ++index) {
            if (this.shouldBeEnabled(this.selectedNodes[index])) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    protected abstract boolean shouldBeEnabled(ApplicationNode var1);

    @Override
    public void setUp() {
        super.setUp();
        this.selectedNodes = this.selectedNodes();
        this.engageListeners();
        this.updateEnabledState();
    }

    @Override
    public void tearDown() {
        this.disengageListeners();
        this.selectedNodes = null;
        super.tearDown();
    }

    protected void engageListeners() {
        for (int i = 0; i < this.selectedNodes.length; ++i) {
            this.engageListeners((AbstractApplicationNode)this.selectedNodes[i]);
        }
    }

    protected void engageListeners(AbstractApplicationNode node) {
        this.engageValueEnabled(node);
    }

    protected void disengageListeners() {
        for (int i = 0; i < this.selectedNodes.length; ++i) {
            this.disengageListeners((AbstractApplicationNode)this.selectedNodes[i]);
        }
    }

    protected void disengageListeners(AbstractApplicationNode node) {
        this.disengageValueEnabled(node);
    }

    protected void engageValueEnabled(AbstractApplicationNode node) {
        this.engageValue(node, this.enabledPropertyNames(), this.getEnabledStateListener());
    }

    protected void engageValue(AbstractApplicationNode node, String[] propertyNames, PropertyChangeListener listener) {
        this.engage(node, propertyNames, listener);
    }

    protected void engage(AbstractApplicationNode node, String[] propertyNames, PropertyChangeListener listener) {
        int i = propertyNames.length;
        while (i-- > 0) {
            this.engage(node, propertyNames[i], listener);
        }
    }

    protected void engage(AbstractApplicationNode node, String propertyName, PropertyChangeListener listener) {
        node.addValuePropertyChangeListener(propertyName, listener);
    }

    protected void disengageValueEnabled(AbstractApplicationNode node) {
        this.disengageValue(node, this.enabledPropertyNames(), this.getEnabledStateListener());
    }

    protected void disengageValue(AbstractApplicationNode node, String[] propertyNames, PropertyChangeListener listener) {
        this.disengage(node, propertyNames, listener);
    }

    protected void disengage(AbstractApplicationNode node, String[] propertyNames, PropertyChangeListener listener) {
        int i = propertyNames.length;
        while (i-- > 0) {
            this.disengage(node, propertyNames[i], listener);
        }
    }

    protected void disengage(AbstractApplicationNode node, String propertyName, PropertyChangeListener listener) {
        node.removeValuePropertyChangeListener(propertyName, listener);
    }

    protected PropertyChangeListener getEnabledStateListener() {
        if (this.enabledStateListener == null) {
            this.enabledStateListener = this.buildEnabledStateListener();
        }
        return this.enabledStateListener;
    }

    protected PropertyChangeListener buildEnabledStateListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractEnablableFrameworkAction.this.updateEnabledState();
            }
        };
    }

    protected String[] enabledPropertyNames() {
        return DEFAULT_ENABLED_PROPERTY_NAMES;
    }
}

