/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.internal.example.collab.CollabClient;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.ecf.internal.example.collab.start.AccountStart;
import org.eclipse.ecf.internal.example.collab.start.ConnectionDetails;
import org.eclipse.ecf.ui.dialogs.ContainerConnectErrorDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class URIClientConnectAction
implements IWorkbenchWindowActionDelegate {
    protected CollabClient client = CollabClient.getDefault();
    protected String containerType = null;
    protected String uri = null;
    protected String nickname = null;
    protected String password = null;
    protected IResource project = null;
    protected String projectName = null;
    protected boolean autoLogin = false;

    public URIClientConnectAction() {
    }

    public URIClientConnectAction(String containerType, String uri, String nickname, String password, IResource project, boolean autoLoginFlag) {
        this();
        this.containerType = containerType;
        this.uri = uri;
        this.nickname = nickname;
        this.password = password;
        this.autoLogin = autoLoginFlag;
        this.setProject(project);
    }

    public void setProject(IResource project) {
        if (project == null) {
            project = ResourcesPlugin.getWorkspace().getRoot();
        }
        this.project = project;
        this.projectName = CollabClient.getNameForResource(project);
    }

    public void run(IAction action) {
        new ClientConnectJob(NLS.bind((String)Messages.URIClientConnectAction_CONNECT_JOB_NAME, (Object)this.projectName)).schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public class ClientConnectJob
    extends Job {
        public ClientConnectJob(String name) {
            super(name);
        }

        public IStatus run(IProgressMonitor pm) {
            try {
                URIClientConnectAction.this.client.createAndConnectClient(URIClientConnectAction.this.containerType, URIClientConnectAction.this.uri, URIClientConnectAction.this.nickname, URIClientConnectAction.this.password, URIClientConnectAction.this.project);
                if (URIClientConnectAction.this.autoLogin) {
                    this.saveAutoLoginInfo();
                }
            }
            catch (ContainerConnectException e) {
                this.removeAutoLoginInfo();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        new ContainerConnectErrorDialog(null, ((ClientConnectJob)ClientConnectJob.this).URIClientConnectAction.this.uri, e.getStatus()).open();
                    }
                });
            }
            catch (Exception e) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        new ContainerConnectErrorDialog(null, ((ClientConnectJob)ClientConnectJob.this).URIClientConnectAction.this.uri, (Throwable)e).open();
                    }
                });
            }
            return Status.OK_STATUS;
        }

        private void saveAutoLoginInfo() {
            AccountStart as = new AccountStart();
            as.addConnectionDetails(new ConnectionDetails(URIClientConnectAction.this.containerType, URIClientConnectAction.this.uri, URIClientConnectAction.this.nickname, URIClientConnectAction.this.password));
            as.saveConnectionDetailsToPreferenceStore();
        }

        private void removeAutoLoginInfo() {
            AccountStart as = new AccountStart();
            as.removeConnectionDetails(new ConnectionDetails(URIClientConnectAction.this.containerType, URIClientConnectAction.this.uri, URIClientConnectAction.this.nickname, URIClientConnectAction.this.password));
        }
    }
}

