/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.remoteservice.client.IRemoteCallParameter;

public class RemoteCallParameter
implements IRemoteCallParameter {
    private String name;
    private Object value;

    public RemoteCallParameter(String name, Object value) {
        this.name = name;
        Assert.isNotNull((Object)this.name);
        this.value = value;
    }

    public RemoteCallParameter(String name) {
        this(name, null);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("RemoteCallParameter[name=");
        buffer.append(this.name);
        buffer.append(", value=");
        buffer.append(this.value);
        buffer.append("]");
        return buffer.toString();
    }

    public static class Builder {
        private final Map<String, Object> nameDefaultValueMap = new HashMap<String, Object>();

        public Builder addParameter(String name, Object defaultValue) {
            this.nameDefaultValueMap.put(name, defaultValue);
            return this;
        }

        public Builder addParameter(String name) {
            return this.addParameter(name, null);
        }

        public IRemoteCallParameter[] build() {
            ArrayList<RemoteCallParameter> params = new ArrayList<RemoteCallParameter>();
            for (String name : this.nameDefaultValueMap.keySet()) {
                Object value = this.nameDefaultValueMap.get(name);
                params.add(value == null ? new RemoteCallParameter(name) : new RemoteCallParameter(name, value));
            }
            return params.size() == 0 ? null : params.toArray(new IRemoteCallParameter[params.size()]);
        }
    }
}

