/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.SyncPacketSend;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.BytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.CloseListener;
import org.jivesoftware.smackx.bytestreams.ibb.DataListener;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.InitiationListener;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InBandBytestreamManager
implements BytestreamManager {
    public static final String NAMESPACE = "http://jabber.org/protocol/ibb";
    public static final int MAXIMUM_BLOCK_SIZE = 65535;
    private static final String SESSION_ID_PREFIX = "jibb_";
    private static final Random randomGenerator;
    private static final Map<Connection, InBandBytestreamManager> managers;
    private final Connection connection;
    private final Map<String, BytestreamListener> userListeners = new ConcurrentHashMap<String, BytestreamListener>();
    private final List<BytestreamListener> allRequestListeners = Collections.synchronizedList(new LinkedList());
    private final InitiationListener initiationListener;
    private final DataListener dataListener;
    private final CloseListener closeListener;
    private final Map<String, InBandBytestreamSession> sessions = new ConcurrentHashMap<String, InBandBytestreamSession>();
    private int defaultBlockSize = 4096;
    private int maximumBlockSize = 65535;
    private StanzaType stanza = StanzaType.IQ;
    private List<String> ignoredBytestreamRequests = Collections.synchronizedList(new LinkedList());

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            public void connectionCreated(Connection connection) {
                final InBandBytestreamManager manager = InBandBytestreamManager.getByteStreamManager(connection);
                connection.addConnectionListener(new AbstractConnectionListener(){

                    public void connectionClosed() {
                        manager.disableService();
                    }
                });
            }
        });
        randomGenerator = new Random();
        managers = new HashMap<Connection, InBandBytestreamManager>();
    }

    public static synchronized InBandBytestreamManager getByteStreamManager(Connection connection) {
        if (connection == null) {
            return null;
        }
        InBandBytestreamManager manager = managers.get(connection);
        if (manager == null) {
            manager = new InBandBytestreamManager(connection);
            managers.put(connection, manager);
        }
        return manager;
    }

    private InBandBytestreamManager(Connection connection) {
        this.connection = connection;
        this.initiationListener = new InitiationListener(this);
        this.connection.addPacketListener(this.initiationListener, this.initiationListener.getFilter());
        this.dataListener = new DataListener(this);
        this.connection.addPacketListener(this.dataListener, this.dataListener.getFilter());
        this.closeListener = new CloseListener(this);
        this.connection.addPacketListener(this.closeListener, this.closeListener.getFilter());
    }

    @Override
    public void addIncomingBytestreamListener(BytestreamListener listener) {
        this.allRequestListeners.add(listener);
    }

    @Override
    public void removeIncomingBytestreamListener(BytestreamListener listener) {
        this.allRequestListeners.remove(listener);
    }

    @Override
    public void addIncomingBytestreamListener(BytestreamListener listener, String initiatorJID) {
        this.userListeners.put(initiatorJID, listener);
    }

    @Override
    public void removeIncomingBytestreamListener(String initiatorJID) {
        this.userListeners.remove(initiatorJID);
    }

    public void ignoreBytestreamRequestOnce(String sessionID) {
        this.ignoredBytestreamRequests.add(sessionID);
    }

    public int getDefaultBlockSize() {
        return this.defaultBlockSize;
    }

    public void setDefaultBlockSize(int defaultBlockSize) {
        if (defaultBlockSize <= 0 || defaultBlockSize > 65535) {
            throw new IllegalArgumentException("Default block size must be between 1 and 65535");
        }
        this.defaultBlockSize = defaultBlockSize;
    }

    public int getMaximumBlockSize() {
        return this.maximumBlockSize;
    }

    public void setMaximumBlockSize(int maximumBlockSize) {
        if (maximumBlockSize <= 0 || maximumBlockSize > 65535) {
            throw new IllegalArgumentException("Maximum block size must be between 1 and 65535");
        }
        this.maximumBlockSize = maximumBlockSize;
    }

    public StanzaType getStanza() {
        return this.stanza;
    }

    public void setStanza(StanzaType stanza) {
        this.stanza = stanza;
    }

    @Override
    public InBandBytestreamSession establishSession(String targetJID) throws XMPPException {
        String sessionID = this.getNextSessionID();
        return this.establishSession(targetJID, sessionID);
    }

    @Override
    public InBandBytestreamSession establishSession(String targetJID, String sessionID) throws XMPPException {
        Open byteStreamRequest = new Open(sessionID, this.defaultBlockSize, this.stanza);
        byteStreamRequest.setTo(targetJID);
        SyncPacketSend.getReply(this.connection, byteStreamRequest);
        InBandBytestreamSession inBandBytestreamSession = new InBandBytestreamSession(this.connection, byteStreamRequest, targetJID);
        this.sessions.put(sessionID, inBandBytestreamSession);
        return inBandBytestreamSession;
    }

    protected void replyRejectPacket(IQ request) {
        XMPPError xmppError = new XMPPError(XMPPError.Condition.no_acceptable);
        IQ error = IQ.createErrorResponse(request, xmppError);
        this.connection.sendPacket(error);
    }

    protected void replyResourceConstraintPacket(IQ request) {
        XMPPError xmppError = new XMPPError(XMPPError.Condition.resource_constraint);
        IQ error = IQ.createErrorResponse(request, xmppError);
        this.connection.sendPacket(error);
    }

    protected void replyItemNotFoundPacket(IQ request) {
        XMPPError xmppError = new XMPPError(XMPPError.Condition.item_not_found);
        IQ error = IQ.createErrorResponse(request, xmppError);
        this.connection.sendPacket(error);
    }

    private String getNextSessionID() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(SESSION_ID_PREFIX);
        buffer.append(Math.abs(randomGenerator.nextLong()));
        return buffer.toString();
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected BytestreamListener getUserListener(String initiator) {
        return this.userListeners.get(initiator);
    }

    protected List<BytestreamListener> getAllRequestListeners() {
        return this.allRequestListeners;
    }

    protected Map<String, InBandBytestreamSession> getSessions() {
        return this.sessions;
    }

    protected List<String> getIgnoredBytestreamRequests() {
        return this.ignoredBytestreamRequests;
    }

    private void disableService() {
        managers.remove(this.connection);
        this.connection.removePacketListener(this.initiationListener);
        this.connection.removePacketListener(this.dataListener);
        this.connection.removePacketListener(this.closeListener);
        this.initiationListener.shutdown();
        this.userListeners.clear();
        this.allRequestListeners.clear();
        this.sessions.clear();
        this.ignoredBytestreamRequests.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StanzaType {
        IQ,
        MESSAGE;

    }
}

