/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.irc.ui.wizards;

import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.internal.irc.ui.Activator;
import org.eclipse.ecf.internal.irc.ui.IRCUI;
import org.eclipse.ecf.internal.irc.ui.Messages;
import org.eclipse.ecf.internal.irc.ui.wizards.IRCConnectWizardPage;
import org.eclipse.ecf.internal.provider.irc.identity.IRCID;
import org.eclipse.ecf.presence.chatroom.IChatRoomManager;
import org.eclipse.ecf.ui.IConnectWizard;
import org.eclipse.ecf.ui.actions.AsynchContainerConnectAction;
import org.eclipse.ecf.ui.dialogs.IDCreateErrorDialog;
import org.eclipse.ecf.ui.util.PasswordCacheHelper;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public final class IRCConnectWizard
extends Wizard
implements IConnectWizard,
INewWizard {
    public static final String DEFAULT_GUEST_USER = "guest";
    private IRCConnectWizardPage page;
    private IContainer container;
    private ID targetID;
    private IConnectContext connectContext;
    private String authorityAndPath = null;

    public IRCConnectWizard() {
    }

    public IRCConnectWizard(String authorityAndPart) {
        this.authorityAndPath = authorityAndPart;
    }

    public void addPages() {
        this.page = new IRCConnectWizardPage(this.authorityAndPath);
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench workbench, IContainer container) {
        this.container = container;
        this.setWindowTitle(Messages.IRCConnectWizard_WIZARD_TITLE);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.container = null;
        try {
            this.container = ContainerFactory.getDefault().createContainer("ecf.irc.irclib");
        }
        catch (ContainerCreateException containerCreateException) {
            // empty catch block
        }
        this.setWindowTitle(Messages.IRCConnectWizard_WIZARD_TITLE);
    }

    public boolean performCancel() {
        this.container.dispose();
        IContainerManager containerManager = Activator.getDefault().getContainerManager();
        if (containerManager != null) {
            containerManager.removeContainer(this.container);
        }
        return super.performCancel();
    }

    public boolean performFinish() {
        final String connectID = this.page.getConnectID();
        final String password = this.page.getPassword();
        this.connectContext = ConnectContextFactory.createPasswordConnectContext((String)password);
        this.page.saveComboText();
        try {
            this.targetID = IDFactory.getDefault().createID(this.container.getConnectNamespace(), connectID);
        }
        catch (IDCreateException e) {
            new IDCreateErrorDialog(null, connectID, e).open();
            return false;
        }
        IChatRoomManager manager = (IChatRoomManager)this.container.getAdapter(IChatRoomManager.class);
        IRCUI ui = new IRCUI(this.container, manager, null);
        ui.showForTarget(this.targetID);
        if (!ui.isContainerConnected()) {
            this.page.saveComboItems();
            IRCID id = (IRCID)this.targetID;
            StringBuffer buffer = new StringBuffer(id.getUsername());
            buffer.append('@').append(id.getHost());
            buffer.append(':').append(id.getPort());
            id = (IRCID)this.container.getConnectNamespace().createInstance(new Object[]{buffer.toString()});
            new AsynchContainerConnectAction(this.container, (ID)id, this.connectContext, null, new Runnable(){

                @Override
                public void run() {
                    IRCConnectWizard.this.cachePassword(IRCConnectWizard.this.page.getPasswordKeyFromUserName(connectID), password);
                }
            }).run();
        }
        return true;
    }

    protected void cachePassword(String connectID, String password) {
        if (password != null && !password.equals("")) {
            PasswordCacheHelper pwStorage = new PasswordCacheHelper(connectID);
            pwStorage.savePassword(password);
        }
    }
}

