/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.ecf.core.events.ContainerConnectedEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectedEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectConfig;
import org.eclipse.ecf.core.sharedobject.SharedObjectInitException;
import org.eclipse.ecf.core.sharedobject.events.RemoteSharedObjectCreateResponseEvent;
import org.eclipse.ecf.core.sharedobject.events.RemoteSharedObjectEvent;
import org.eclipse.ecf.core.sharedobject.events.SharedObjectActivatedEvent;
import org.eclipse.ecf.core.sharedobject.events.SharedObjectDeactivatedEvent;
import org.eclipse.ecf.core.sharedobject.util.IQueueEnqueue;
import org.eclipse.ecf.core.sharedobject.util.QueueEnqueueImpl;
import org.eclipse.ecf.core.sharedobject.util.SimpleFIFOQueue;
import org.eclipse.ecf.core.util.Event;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.provider.generic.ContainerMessage;
import org.eclipse.ecf.provider.generic.SOConfig;
import org.eclipse.ecf.provider.generic.SOContainer;
import org.eclipse.ecf.provider.generic.SOContainerGMM;
import org.eclipse.ecf.provider.generic.gmm.Member;

public class SOWrapper {
    protected ISharedObject sharedObject;
    private SOConfig sharedObjectConfig;
    ID sharedObjectID;
    private SOContainer container;
    private ID containerID;
    private Thread thread;
    SimpleFIFOQueue queue;

    protected SOWrapper(SOContainer.LoadingSharedObject obj, SOContainer cont) {
        this.sharedObjectID = obj.getID();
        this.sharedObject = obj;
        this.container = cont;
        this.containerID = cont.getID();
        this.sharedObjectConfig = null;
        this.thread = null;
        this.queue = new SimpleFIFOQueue();
    }

    public SOWrapper(SOConfig aConfig, ISharedObject obj, SOContainer cont) {
        this.sharedObjectConfig = aConfig;
        this.sharedObjectID = this.sharedObjectConfig.getSharedObjectID();
        this.sharedObject = obj;
        this.container = cont;
        this.containerID = cont.getID();
        this.thread = null;
        this.queue = new SimpleFIFOQueue();
    }

    protected void init() throws SharedObjectInitException {
        this.debug("init()");
        this.sharedObjectConfig.makeActive((IQueueEnqueue)new QueueEnqueueImpl(this.queue));
        this.sharedObject.init((ISharedObjectConfig)this.sharedObjectConfig);
    }

    protected ID getObjID() {
        return this.sharedObjectConfig.getSharedObjectID();
    }

    protected ID getHomeID() {
        return this.sharedObjectConfig.getHomeContainerID();
    }

    protected SOConfig getConfig() {
        return this.sharedObjectConfig;
    }

    protected void activated() {
        this.thread = (Thread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread aThread = SOWrapper.this.getThread();
                return aThread;
            }
        });
        this.container.notifySharedObjectActivated(this.sharedObjectID);
        this.thread.start();
        this.send((Event)new SharedObjectActivatedEvent(this.containerID, this.sharedObjectID));
    }

    protected void deactivated() {
        this.container.notifySharedObjectDeactivated(this.sharedObjectID);
        this.send((Event)new SharedObjectDeactivatedEvent(this.containerID, this.sharedObjectID));
        this.destroyed();
    }

    protected void destroyed() {
        if (!this.queue.isStopped()) {
            if (this.thread != null) {
                this.queue.enqueue((Object)new DisposeEvent());
            }
            this.queue.close();
        }
    }

    protected void otherChanged(ID otherID, boolean activated) {
        if (activated && this.thread != null) {
            this.send((Event)new SharedObjectActivatedEvent(this.containerID, otherID));
        } else {
            this.send((Event)new SharedObjectDeactivatedEvent(this.containerID, otherID));
        }
    }

    protected void memberChanged(Member m, boolean add) {
        if (this.thread != null) {
            if (add) {
                this.send((Event)new ContainerConnectedEvent(this.containerID, m.getID()));
            } else {
                this.send((Event)new ContainerDisconnectedEvent(this.containerID, m.getID()));
            }
        }
    }

    protected Thread getThread() {
        return this.container.getNewSharedObjectThread(this.sharedObjectID, new Runnable(){

            @Override
            public void run() {
                SOWrapper.this.debug("runner(" + SOWrapper.this.sharedObjectID + ")");
                Event evt = null;
                while (!Thread.currentThread().isInterrupted()) {
                    evt = (Event)SOWrapper.this.queue.dequeue();
                    if (Thread.currentThread().isInterrupted() || evt == null) break;
                    try {
                        if (evt instanceof ProcEvent) {
                            SOWrapper.this.svc(((ProcEvent)evt).getEvent());
                            continue;
                        }
                        if (evt instanceof DisposeEvent) {
                            SOWrapper.this.doDestroy();
                            continue;
                        }
                        SOWrapper.this.svc(evt);
                    }
                    catch (Throwable t) {
                        SOWrapper.this.handleRuntimeException(t);
                    }
                }
                if (Thread.currentThread().isInterrupted()) {
                    SOWrapper.this.debug("runner(" + SOWrapper.this.sharedObjectID + ") terminating interrupted");
                } else {
                    SOWrapper.this.debug("runner(" + SOWrapper.this.sharedObjectID + ") terminating normally");
                }
            }
        });
    }

    private void send(Event evt) {
        this.queue.enqueue((Object)new ProcEvent(evt));
    }

    protected void svc(Event evt) {
        this.sharedObject.handleEvent(evt);
    }

    protected void doDestroy() {
        this.sharedObject.dispose(this.containerID);
        this.sharedObjectConfig.makeInactive();
    }

    protected void deliverSharedObjectMessage(ID fromID, Serializable data) {
        this.send((Event)new RemoteSharedObjectEvent(this.getObjID(), fromID, (Object)data));
    }

    protected void deliverCreateResponse(ID fromID, ContainerMessage.CreateResponseMessage resp) {
        this.send((Event)new RemoteSharedObjectCreateResponseEvent(resp.getSharedObjectID(), fromID, resp.getSequence(), resp.getException()));
    }

    public void deliverEvent(Event evt) {
        this.send(evt);
    }

    protected void destroySelf() {
        this.debug("destroySelf()");
        this.send(new DisposeEvent());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SharedObjectWrapper[").append(this.getObjID()).append("]");
        return sb.toString();
    }

    protected void debug(String msg) {
        Trace.trace((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/sharedobjectwrapper", (String)(String.valueOf(msg) + ":oID=" + this.sharedObjectID + ":cID=" + this.container.getID()));
    }

    protected void traceStack(String msg, Throwable e) {
        Trace.catching((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/exceptions/catching", SOContainerGMM.class, (String)(this.container.getID() + ":" + msg), (Throwable)e);
    }

    protected void handleRuntimeException(Throwable except) {
        except.printStackTrace(System.err);
        this.traceStack("runner:handleRuntimeException(" + this.sharedObjectID.getName() + ")", except);
    }

    protected ISharedObject getSharedObject() {
        return this.sharedObject;
    }

    public SimpleFIFOQueue getQueue() {
        return this.queue;
    }

    protected static class DisposeEvent
    implements Event {
        DisposeEvent() {
        }
    }

    public static class ProcEvent
    implements Event {
        Event theEvent = null;

        public ProcEvent(Event event) {
            this.theEvent = event;
        }

        Event getEvent() {
            return this.theEvent;
        }
    }
}

