/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.identity;

import java.io.Serializable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.identity.BaseID;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.internal.core.identity.Activator;

public abstract class Namespace
implements Serializable,
IAdaptable {
    private static final long serialVersionUID = 3976740272094720312L;
    public static final String SCHEME_SEPARATOR = ":";
    private String name;
    private String description;
    private transient int hashCode;
    private transient boolean isInitialized = false;

    public Namespace() {
    }

    public final boolean initialize(String n, String desc) {
        Assert.isNotNull((Object)n, (String)"Namespace<init> name cannot be null");
        if (!this.isInitialized) {
            this.name = n;
            this.description = desc;
            this.hashCode = this.name.hashCode();
            this.isInitialized = true;
            return true;
        }
        return false;
    }

    public Namespace(String name, String desc) {
        this.initialize(name, desc);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Namespace)) {
            return false;
        }
        return ((Namespace)other).name.equals(this.name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected boolean testIDEquals(BaseID first, BaseID second) {
        Namespace sn = second.getNamespace();
        if (sn == null || !this.equals(sn)) {
            return false;
        }
        return first.namespaceEquals(second);
    }

    protected String getNameForID(BaseID id) {
        return id.namespaceGetName();
    }

    protected int getCompareToForObject(BaseID first, BaseID second) {
        return first.namespaceCompareTo(second);
    }

    protected int getHashCodeForID(BaseID id) {
        return id.namespaceHashCode();
    }

    protected String toExternalForm(BaseID id) {
        return id.namespaceToExternalForm();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract ID createInstance(Object[] var1) throws IDCreateException;

    public abstract String getScheme();

    public String[] getSupportedSchemes() {
        return new String[0];
    }

    public Class<?>[][] getSupportedParameterTypes() {
        return new Class[][]{new Class[0]};
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        IAdapterManager manager = Activator.getDefault().getAdapterManager();
        if (manager == null) {
            return null;
        }
        return manager.loadAdapter((Object)this, adapter.getName());
    }

    protected String getInitStringFromExternalForm(Object[] args) {
        String arg;
        if (args == null || args.length < 1 || args[0] == null) {
            return null;
        }
        if (args[0] instanceof String && (arg = (String)args[0]).startsWith(String.valueOf(this.getScheme()) + SCHEME_SEPARATOR)) {
            int index = arg.indexOf(SCHEME_SEPARATOR);
            if (index >= arg.length()) {
                return null;
            }
            return arg.substring(index + 1);
        }
        return null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("Namespace[");
        b.append("name=").append(this.name).append(";");
        b.append("scheme=").append(this.getScheme()).append(";");
        b.append("description=").append("]");
        return b.toString();
    }
}

