/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jslp.identity;

import ch.ethz.iks.slp.ServiceType;
import ch.ethz.iks.slp.ServiceURL;
import java.net.URI;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceTypeID;
import org.eclipse.ecf.provider.jslp.identity.JSLPServiceID;
import org.eclipse.ecf.provider.jslp.identity.JSLPServiceTypeID;

public class JSLPNamespace
extends Namespace {
    private static final String JSLP_SCHEME = "jslp";
    private static final long serialVersionUID = -3041453162456476102L;
    public static final String NAME = "ecf.namespace.slp";

    public JSLPNamespace() {
        super(NAME, "JSLP Namespace");
    }

    public ID createInstance(Object[] parameters) {
        if (parameters == null || parameters.length < 1 || parameters.length > 2) {
            throw new IDCreateException("Parameters cannot be null and must be of length 1 or 2");
        }
        if (parameters[0] == null || parameters[0].equals("")) {
            throw new IDCreateException("First parameter cannot be null or empty String");
        }
        if (parameters.length == 2 && parameters[0] instanceof ServiceURL) {
            ServiceURL anURL = (ServiceURL)parameters[0];
            String[] scopes = (String[])parameters[1];
            return new JSLPServiceTypeID(this, anURL, scopes);
        }
        if (parameters.length == 1 && parameters[0] instanceof JSLPServiceID) {
            return (ID)parameters[0];
        }
        if (parameters.length == 1 && parameters[0] instanceof IServiceID) {
            IServiceID anId = (IServiceID)parameters[0];
            Object[] newParams = new Object[]{anId.getServiceTypeID(), anId.getName()};
            return this.createInstance(newParams);
        }
        if (parameters[0] instanceof IServiceTypeID) {
            IServiceTypeID stid = (IServiceTypeID)parameters[0];
            parameters[0] = stid.getName();
            return this.createInstance(parameters);
        }
        if (parameters.length == 1 && parameters[0] instanceof ServiceType) {
            return new JSLPServiceTypeID((Namespace)this, (ServiceType)parameters[0]);
        }
        if (parameters[0] instanceof String && ((String)parameters[0]).startsWith("service:")) {
            parameters[0] = new ServiceType((String)parameters[0]);
            return this.createInstance(parameters);
        }
        if (parameters.length == 2 && parameters[0] instanceof String && ((String)parameters[0]).startsWith("_") && parameters[1] instanceof URI) {
            String type = (String)parameters[0];
            URI anURI = (URI)parameters[1];
            JSLPServiceTypeID serviceType = new JSLPServiceTypeID((Namespace)this, (IServiceTypeID)new ServiceTypeID((Namespace)this, type));
            return new JSLPServiceID(this, (IServiceTypeID)serviceType, anURI);
        }
        if (parameters.length == 1 && parameters[0] instanceof String && ((String)parameters[0]).startsWith("_")) {
            String type = (String)parameters[0];
            return new JSLPServiceTypeID((Namespace)this, (IServiceTypeID)new ServiceTypeID((Namespace)this, type));
        }
        if (parameters.length == 2 && parameters[1] != null && !(parameters[1] instanceof String)) {
            throw new IDCreateException("Second parameter must be of type String");
        }
        throw new IDCreateException("Wrong JSLPServiceID creation parameters");
    }

    public String getScheme() {
        return JSLP_SCHEME;
    }

    public Class[][] getSupportedParameterTypes() {
        return new Class[][]{{String.class}, {String.class, String.class}, {ServiceURL.class, String[].class, String.class}, {IServiceTypeID.class}, {IServiceID.class}, {ServiceType.class, String.class}};
    }
}

