/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.serialization.metadata;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.rmf.serialization.XMLPersistenceMappingExtendedMetaData;
import org.eclipse.rmf.serialization.XMLPersistenceMappingExtendedMetaDataImpl;
import org.eclipse.rmf.tests.serialization.model.nodes.NodesPackage;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class XMLPersistenceExtendedMetaDataTests {
    int[] identitySerializationStructureConfiguration;

    public XMLPersistenceExtendedMetaDataTests() {
        int[] nArray = new int[16];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 14;
        nArray[15] = 15;
        this.identitySerializationStructureConfiguration = nArray;
    }

    @BeforeClass
    public static void setup() {
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/rmf/serialization/model/nodes.ecore", (Object)NodesPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
    }

    @Test
    public void testMetadataIsSingleton() {
        XMLPersistenceMappingExtendedMetaData metadata1 = XMLPersistenceMappingExtendedMetaData.INSTANCE;
        XMLPersistenceMappingExtendedMetaData metadata2 = XMLPersistenceMappingExtendedMetaData.INSTANCE;
        Assert.assertSame((Object)metadata1, (Object)metadata2);
    }

    @Test
    public void testGetFeatureSerializationStructureSingle() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        int i = 0;
        while (i < this.identitySerializationStructureConfiguration.length) {
            String featureName = "eReference_Contained" + this.toBinaryString(i) + "Single";
            EStructuralFeature feature = nodeEClass.getEStructuralFeature(featureName);
            Assert.assertNotNull((String)("EReference '" + featureName + "' not found"), (Object)feature);
            int featureSerializationStructure = metadata.getFeatureSerializationStructure(feature);
            Assert.assertSame((Object)i, (Object)featureSerializationStructure);
            ++i;
        }
    }

    @Test
    public void testGetFeatureSerializationStructureMany() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        int i = 0;
        while (i < this.identitySerializationStructureConfiguration.length) {
            String featureName = "eReference_Contained" + this.toBinaryString(i) + "Many";
            EStructuralFeature feature = nodeEClass.getEStructuralFeature(featureName);
            Assert.assertNotNull((String)("EReference '" + featureName + "' not found"), (Object)feature);
            int featureSerializationStructure = metadata.getFeatureSerializationStructure(feature);
            Assert.assertSame((Object)i, (Object)featureSerializationStructure);
            ++i;
        }
    }

    @Test
    public void testGetFeatureSerializationStructure_EReference_ReferencedxxxxSingle() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        int i = 0;
        while (i < this.identitySerializationStructureConfiguration.length) {
            String featureName = "eReference_Referenced" + this.toBinaryString(i) + "Single";
            EStructuralFeature feature = nodeEClass.getEStructuralFeature(featureName);
            Assert.assertNotNull((String)("EReference '" + featureName + "' not found"), (Object)feature);
            int featureSerializationStructure = metadata.getFeatureSerializationStructure(feature);
            Assert.assertSame((Object)i, (Object)featureSerializationStructure);
            ++i;
        }
    }

    @Test
    public void testGetFeatureSerializationStructure_EReference_ReferencedxxxxMany() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        int i = 0;
        while (i < this.identitySerializationStructureConfiguration.length) {
            String featureName = "eReference_Referenced" + this.toBinaryString(i) + "Many";
            EStructuralFeature feature = nodeEClass.getEStructuralFeature(featureName);
            Assert.assertNotNull((String)("EReference '" + featureName + "' not found"), (Object)feature);
            int featureSerializationStructure = metadata.getFeatureSerializationStructure(feature);
            Assert.assertSame((Object)i, (Object)featureSerializationStructure);
            ++i;
        }
    }

    @Test
    public void testGetFeatureSerializationStructure_EAttribute_AttributexxxxSingle() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        int i = 0;
        while (i < this.identitySerializationStructureConfiguration.length) {
            String featureName = "eAttribute_Attribute" + this.toBinaryString(i) + "Single";
            EStructuralFeature feature = nodeEClass.getEStructuralFeature(featureName);
            Assert.assertNotNull((String)("EAttribute '" + featureName + "' not found"), (Object)feature);
            int featureSerializationStructure = metadata.getFeatureSerializationStructure(feature);
            Assert.assertSame((Object)i, (Object)featureSerializationStructure);
            ++i;
        }
    }

    @Test
    public void testGetFeatureSerializationStructure_EAttribute_AttributexxxxMany() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        int i = 0;
        while (i < this.identitySerializationStructureConfiguration.length) {
            String featureName = "eAttribute_Attribute" + this.toBinaryString(i) + "Many";
            EStructuralFeature feature = nodeEClass.getEStructuralFeature(featureName);
            Assert.assertNotNull((String)("Attribute '" + featureName + "' not found"), (Object)feature);
            int featureSerializationStructure = metadata.getFeatureSerializationStructure(feature);
            Assert.assertSame((Object)i, (Object)featureSerializationStructure);
            ++i;
        }
    }

    @Test
    public void testGetFeatureSerializationStructure_EmptyAnnotation_Single() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EReference feature = NodesPackage.eINSTANCE.getNode_EReference_EmptyAnnotationSingle();
        int featureSerializationStructure = metadata.getFeatureSerializationStructure((EStructuralFeature)feature);
        Assert.assertSame((Object)9, (Object)featureSerializationStructure);
    }

    @Test
    public void testGetFeatureSerializationStructure_NoAnnotation_Single() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EReference feature = NodesPackage.eINSTANCE.getNode_EReference_NoAnnotationSingle();
        int featureSerializationStructure = metadata.getFeatureSerializationStructure((EStructuralFeature)feature);
        Assert.assertSame((Object)4, (Object)featureSerializationStructure);
    }

    @Test
    public void testGetFeatureSerializationStructure_EmptyAnnotationMany() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EReference feature = NodesPackage.eINSTANCE.getNode_EReference_EmptyAnnotationMany();
        int featureSerializationStructure = metadata.getFeatureSerializationStructure((EStructuralFeature)feature);
        Assert.assertSame((Object)9, (Object)featureSerializationStructure);
    }

    @Test
    public void testGetFeatureSerializationStructure_NoAnnotationMany() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EReference feature = NodesPackage.eINSTANCE.getNode_EReference_NoAnnotationMany();
        int featureSerializationStructure = metadata.getFeatureSerializationStructure((EStructuralFeature)feature);
        Assert.assertSame((Object)4, (Object)featureSerializationStructure);
    }

    @Test
    public void testGetTypeByXMLName_Namespace_knownType() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl();
        EClassifier eClassifier = metadata.getTypeByXMLName("http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "NODE");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode(), (Object)eClassifier);
    }

    @Test
    public void testGetTypeByXMLName_EPackage_knownType() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl();
        EClassifier eClassifier = metadata.getTypeByXMLName((EPackage)NodesPackage.eINSTANCE, "NODE");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode(), (Object)eClassifier);
    }

    @Test
    public void testGetTypeByXMLName_EPackage_unKnownType() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl();
        EClassifier eClassifier = metadata.getTypeByXMLName((EPackage)NodesPackage.eINSTANCE, "Node");
        Assert.assertNull((Object)eClassifier);
    }

    @Test
    public void testGetFeatureByXMLElementName_EReference_Contained0000Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "ATTRIBUTE-FROM-NESTED-CLASS");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EReference_Contained0000Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EReference_Contained0001Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "NODE");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EReference_Contained0001Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EReference_Contained0010Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "NODES");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EReference_Contained0010Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EReference_Contained0011Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "NODES");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EReference_Contained0010Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EReference_Contained0100Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "FEATURE-WITH-SERIALIZATION-0100-MULTI");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EReference_Contained0100Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EReference_Contained0101Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "FEATURE-WITH-SERIALIZATION-0101-MULTI");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EReference_Contained0101Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EReference_Contained0110Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "FEATURE-WITH-SERIALIZATION-0110-MULTI");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EReference_Contained0110Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EReference_Contained0111Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "FEATURE-WITH-SERIALIZATION-0111-MULTI");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EReference_Contained0111Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EReference_Contained1000Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "FEATURE-WITH-SERIALIZATION-1000-MULTIS");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EReference_Contained1000Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EReference_Contained1001Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "FEATURE-WITH-SERIALIZATION-1001-MULTIS");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EReference_Contained1001Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EReference_Contained1010Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "FEATURE-WITH-SERIALIZATION-1010-MULTIS");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EReference_Contained1010Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EReference_Contained1011Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "FEATURE-WITH-SERIALIZATION-1011-MULTIS");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EReference_Contained1011Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EReference_Contained1100Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "FEATURE-WITH-SERIALIZATION-1100-MULTIS");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EReference_Contained1100Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EReference_Contained1101Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "FEATURE-WITH-SERIALIZATION-1101-MULTIS");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EReference_Contained1101Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EReference_Contained1110Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "FEATURE-WITH-SERIALIZATION-1110-MULTIS");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EReference_Contained1110Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EReference_Contained1111Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "FEATURE-WITH-SERIALIZATION-1111-MULTIS");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EReference_Contained1111Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EReference_NoAnnotationMany() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "eReference_NoAnnotationMany");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EReference_NoAnnotationMany(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EAttribute_Attribute0010Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "EStrings");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute0010Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EAttribute_Attribute0011Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "EStrings");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute0010Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EAttribute_Attribute0010Many2() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/emf/2002/Ecore", "EStrings");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute0010Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EAttribute_Attribute0100Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "EATTRIBUTE-ATTRIBUTE-0100-MANY");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute0100Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EAttribute_Attribute0101Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "EATTRIBUTE-ATTRIBUTE-0101-MANY");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute0101Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EAttribute_Attribute0110Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "EATTRIBUTE-ATTRIBUTE-0110-MANY");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute0110Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EAttribute_Attribute0111Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "EATTRIBUTE-ATTRIBUTE-0111-MANY");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute0111Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EAttribute_Attribute1000Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "EATTRIBUTE-ATTRIBUTE-1000-MANIES");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute1000Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EAttribute_Attribute1001Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "EATTRIBUTE-ATTRIBUTE-1001-MANIES");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute1001Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EAttribute_Attribute1010Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "EATTRIBUTE-ATTRIBUTE-1010-MANIES");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute1010Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EAttribute_Attribute1011Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "EATTRIBUTE-ATTRIBUTE-1011-MANIES");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute1011Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EAttribute_Attribute1100Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "EATTRIBUTE-ATTRIBUTE-1100-MANIES");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute1100Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EAttribute_Attribute1101Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "EATTRIBUTE-ATTRIBUTE-1101-MANIES");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute1101Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EAttribute_Attribute1110Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "EATTRIBUTE-ATTRIBUTE-1110-MANIES");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute1110Many(), (Object)feature);
    }

    @Test
    public void testGetFeatureByXMLElementName_EAttribute_Attribute1111Many() {
        XMLPersistenceMappingExtendedMetaDataImpl metadata = new XMLPersistenceMappingExtendedMetaDataImpl(this.identitySerializationStructureConfiguration);
        EClass nodeEClass = NodesPackage.eINSTANCE.getNode();
        EStructuralFeature feature = metadata.getFeatureByXMLElementName(nodeEClass, "http://www.eclipse.org/rmf/serialization/model/nodes.ecore", "EATTRIBUTE-ATTRIBUTE-1111-MANIES");
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode_EAttribute_Attribute1111Many(), (Object)feature);
    }

    private String toBinaryString(int serializationStructure) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getBinaryString(serializationStructure, 8));
        buffer.append(this.getBinaryString(serializationStructure, 4));
        buffer.append(this.getBinaryString(serializationStructure, 2));
        buffer.append(this.getBinaryString(serializationStructure, 1));
        return buffer.toString();
    }

    private String getBinaryString(int serializationStructure, int mask) {
        if (mask == (serializationStructure & mask)) {
            return "1";
        }
        return "0";
    }
}

