/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.reqif10.serialization.uc003.tc18xx;

import java.io.IOException;
import junit.framework.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.XhtmlContent;
import org.eclipse.rmf.reqif10.xhtml.XhtmlPType;
import org.eclipse.rmf.tests.reqif10.serialization.uc003.tc18xx.ReqIFUtil;
import org.eclipse.rmf.tests.reqif10.serialization.uc003.tc18xx.TC1800HISExchangeProcessModelBuilder;
import org.eclipse.rmf.tests.reqif10.serialization.uc003.tc18xx.TC1801HISExchangeProcessModelBuilder;
import org.eclipse.rmf.tests.reqif10.serialization.uc003.tc18xx.TC1802HISExchangeProcessModelBuilder;
import org.eclipse.rmf.tests.reqif10.serialization.uc003.tc18xx.TC1803HISExchangeProcessModelBuilder;
import org.eclipse.rmf.tests.reqif10.serialization.util.AbstractTestCase;
import org.eclipse.rmf.tests.reqif10.serialization.util.CommonSystemAttributes;
import org.junit.BeforeClass;
import org.junit.Test;

public class TC18xxHISExchangeProcessTests
extends AbstractTestCase
implements CommonSystemAttributes {
    static final String TC1800_FILENAME = TC18xxHISExchangeProcessTests.getWorkingFileName(TC18xxHISExchangeProcessTests.getReferenceDataFileName("TC1800", false));
    static final String TC1801_FILENAME = TC18xxHISExchangeProcessTests.getWorkingFileName(TC18xxHISExchangeProcessTests.getReferenceDataFileName("TC1801", false));
    static final String TC1802_FILENAME = TC18xxHISExchangeProcessTests.getWorkingFileName(TC18xxHISExchangeProcessTests.getReferenceDataFileName("TC1802", false));
    static final String TC1803_FILENAME = TC18xxHISExchangeProcessTests.getWorkingFileName(TC18xxHISExchangeProcessTests.getReferenceDataFileName("TC1803", false));
    static ReqIF tc1800ReqIF = null;
    static ReqIF tc1801ReqIF = null;
    static ReqIF tc1802ReqIF = null;
    static ReqIF tc1803ReqIF = null;

    @BeforeClass
    public static void setupOnce() throws Exception {
        AbstractTestCase.setupOnce();
        tc1800ReqIF = new TC1800HISExchangeProcessModelBuilder().getReqIF();
        TC18xxHISExchangeProcessTests.doSaveReqIFFile((EObject)tc1800ReqIF, TC1800_FILENAME);
        tc1800ReqIF = TC18xxHISExchangeProcessTests.loadReqIFFile(TC1800_FILENAME);
        tc1801ReqIF = new TC1801HISExchangeProcessModelBuilder(TC18xxHISExchangeProcessTests.loadReqIFFile(TC1800_FILENAME)).getReqIF();
        TC18xxHISExchangeProcessTests.doSaveReqIFFile((EObject)tc1801ReqIF, TC1801_FILENAME);
        tc1801ReqIF = TC18xxHISExchangeProcessTests.loadReqIFFile(TC1801_FILENAME);
        tc1802ReqIF = new TC1802HISExchangeProcessModelBuilder(TC18xxHISExchangeProcessTests.loadReqIFFile(TC1801_FILENAME)).getReqIF();
        TC18xxHISExchangeProcessTests.doSaveReqIFFile((EObject)tc1802ReqIF, TC1802_FILENAME);
        tc1802ReqIF = TC18xxHISExchangeProcessTests.loadReqIFFile(TC1802_FILENAME);
        tc1803ReqIF = new TC1803HISExchangeProcessModelBuilder(TC18xxHISExchangeProcessTests.loadReqIFFile(TC1802_FILENAME)).getReqIF();
        TC18xxHISExchangeProcessTests.doSaveReqIFFile((EObject)tc1803ReqIF, TC1803_FILENAME);
        tc1803ReqIF = TC18xxHISExchangeProcessTests.loadReqIFFile(TC1803_FILENAME);
    }

    @Test
    public void testSchemaCompliance() throws Exception {
        this.validateAgainstSchema(TC1800_FILENAME);
        this.validateAgainstSchema(TC1801_FILENAME);
        this.validateAgainstSchema(TC1802_FILENAME);
        this.validateAgainstSchema(TC1803_FILENAME);
    }

    SpecObject getSpecObjectByName(ReqIF reqif, String name) {
        return (SpecObject)this.getSpecElementByName((EList<? extends SpecElementWithAttributes>)reqif.getCoreContent().getSpecObjects(), name);
    }

    Specification getSpecificationByName(ReqIF reqif, String name) {
        return (Specification)this.getSpecElementByName((EList<? extends SpecElementWithAttributes>)reqif.getCoreContent().getSpecifications(), name);
    }

    private SpecElementWithAttributes getSpecElementByName(EList<? extends SpecElementWithAttributes> list, String name) {
        SpecElementWithAttributes target = null;
        for (SpecElementWithAttributes specObject : list) {
            AttributeValueXHTML value = (AttributeValueXHTML)ReqIFUtil.getAttributeValueForLabel(specObject, "ReqIF.Name");
            XhtmlContent content = value.getTheValue();
            XhtmlPType p = (XhtmlPType)content.getXhtml();
            EAttribute mixedAttribute = null;
            for (EAttribute eAttribute : p.eClass().getEAllAttributes()) {
                if (!"mixed".equals(eAttribute.getName()) || EcorePackage.eINSTANCE.getEFeatureMapEntry() != eAttribute.getEAttributeType()) continue;
                mixedAttribute = eAttribute;
                break;
            }
            FeatureMap featureMap = (FeatureMap)p.eGet(mixedAttribute);
            FeatureMap.Entry entry = (FeatureMap.Entry)featureMap.get(0);
            if (!name.equals(entry.getValue())) continue;
            if (target != null) {
                throw new IllegalStateException("More than one element with name " + name);
            }
            target = specObject;
        }
        return target;
    }

    SpecHierarchy findInSpec(String name, SpecObject specObject) {
        Specification spec = this.getSpecificationByName(ReqIFUtil.getReqIF((EObject)specObject), name);
        if (spec == null) {
            throw new NullPointerException("Spec does not exist: " + name);
        }
        for (SpecHierarchy specHierarchy : spec.getChildren()) {
            SpecObject so = specHierarchy.getObject();
            if (!EcoreUtil.equals((EObject)so, (EObject)specObject)) continue;
            return specHierarchy;
        }
        return null;
    }

    SpecObject[] getObjectsByName(String name) {
        return new SpecObject[]{this.getSpecObjectByName(tc1800ReqIF, name), this.getSpecObjectByName(tc1801ReqIF, name), this.getSpecObjectByName(tc1802ReqIF, name), this.getSpecObjectByName(tc1803ReqIF, name)};
    }

    @Test
    public void testObj01() throws Exception {
        SpecObject[] so = this.getObjectsByName("Obj-01");
        int i = 0;
        while (i < so.length) {
            Assert.assertNotNull((Object)so[i]);
            int j = i + 1;
            while (j < so.length) {
                Assert.assertTrue((boolean)EcoreUtil.equals((EObject)so[i], (EObject)so[j]));
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void testObj03() throws Exception {
        SpecObject[] so = this.getObjectsByName("Obj-03");
        Assert.assertTrue((so[0].getLastChange().getTimeInMillis() < so[1].getLastChange().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertTrue((so[1].getLastChange().getTimeInMillis() < so[2].getLastChange().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertTrue((so[2].getLastChange().getTimeInMillis() < so[3].getLastChange().getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"O3.A1 initial", (Object)ReqIFUtil.getTheValue(ReqIFUtil.getAttributeValueForLabel((SpecElementWithAttributes)so[0], "A1")));
        Assert.assertEquals((Object)"O3.A2 initial", (Object)ReqIFUtil.getTheValue(ReqIFUtil.getAttributeValueForLabel((SpecElementWithAttributes)so[0], "A2")));
        Assert.assertEquals((Object)"O3.A1 initial", (Object)ReqIFUtil.getTheValue(ReqIFUtil.getAttributeValueForLabel((SpecElementWithAttributes)so[1], "A1")));
        Assert.assertEquals((Object)"O3.A2 once", (Object)ReqIFUtil.getTheValue(ReqIFUtil.getAttributeValueForLabel((SpecElementWithAttributes)so[1], "A2")));
        Assert.assertEquals((Object)"O3.A1 once", (Object)ReqIFUtil.getTheValue(ReqIFUtil.getAttributeValueForLabel((SpecElementWithAttributes)so[2], "A1")));
        Assert.assertEquals((Object)"O3.A2 once", (Object)ReqIFUtil.getTheValue(ReqIFUtil.getAttributeValueForLabel((SpecElementWithAttributes)so[2], "A2")));
        Assert.assertEquals((Object)"O3.A1 once", (Object)ReqIFUtil.getTheValue(ReqIFUtil.getAttributeValueForLabel((SpecElementWithAttributes)so[3], "A1")));
        Assert.assertEquals((Object)"O3.A2 twice", (Object)ReqIFUtil.getTheValue(ReqIFUtil.getAttributeValueForLabel((SpecElementWithAttributes)so[3], "A2")));
    }

    @Test
    public void testObj04() throws Exception {
        SpecObject[] so = this.getObjectsByName("Obj-04");
        Assert.assertNull((Object)so[0]);
        int i = 1;
        while (i < so.length) {
            Assert.assertNotNull((Object)so[i]);
            int j = i + 1;
            while (j < so.length) {
                Assert.assertTrue((String)("i=" + i + ", j=" + j), (boolean)EcoreUtil.equals((EObject)so[i], (EObject)so[j]));
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void testObj05() throws Exception {
        SpecObject[] so = this.getObjectsByName("Obj-05");
        Assert.assertNull((Object)so[0]);
        Assert.assertNull((Object)so[1]);
        Assert.assertNull((Object)so[2]);
        Assert.assertEquals((Object)"no change", (Object)ReqIFUtil.getTheValue(ReqIFUtil.getAttributeValueForLabel((SpecElementWithAttributes)so[3], "A1")));
        Assert.assertEquals((Object)"no change", (Object)ReqIFUtil.getTheValue(ReqIFUtil.getAttributeValueForLabel((SpecElementWithAttributes)so[3], "A2")));
    }

    @Test
    public void testObj06() throws Exception {
        SpecObject[] so = this.getObjectsByName("Obj-06");
        Assert.assertEquals((Object)"no change", (Object)ReqIFUtil.getTheValue(ReqIFUtil.getAttributeValueForLabel((SpecElementWithAttributes)so[0], "A1")));
        Assert.assertEquals((Object)"no change", (Object)ReqIFUtil.getTheValue(ReqIFUtil.getAttributeValueForLabel((SpecElementWithAttributes)so[0], "A2")));
        Assert.assertNull((Object)so[1]);
        Assert.assertNull((Object)so[2]);
        Assert.assertNull((Object)so[3]);
    }

    @Test
    public void testObj07() throws Exception {
        SpecObject[] so = this.getObjectsByName("Obj-07");
        Assert.assertNull((Object)so[3]);
        int i = 0;
        while (i < 3) {
            Assert.assertNotNull((Object)so[i]);
            int j = i + 1;
            while (j < 3) {
                Assert.assertTrue((String)("i=" + i + ", j=" + j), (boolean)EcoreUtil.equals((EObject)so[i], (EObject)so[j]));
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void testObj08() throws Exception {
        SpecObject[] so = this.getObjectsByName("Obj-08");
        int i = 0;
        while (i < so.length) {
            Assert.assertNotNull((Object)so[i]);
            int j = i + 1;
            while (j < so.length) {
                Assert.assertTrue((String)("i=" + i + ", j=" + j), (boolean)EcoreUtil.equals((EObject)so[i], (EObject)so[j]));
                ++j;
            }
            ++i;
        }
        SpecHierarchy sh0 = this.findInSpec("Spec1", so[0]);
        Assert.assertNotNull((Object)sh0);
        Assert.assertNull((Object)this.findInSpec("Spec2", so[0]));
        int i2 = 1;
        while (i2 < 4) {
            Assert.assertNull((Object)this.findInSpec("Spec1", so[i2]));
            SpecHierarchy shx = this.findInSpec("Spec2", so[i2]);
            Assert.assertNotNull((Object)shx);
            Assert.assertTrue((sh0.getLastChange().getTimeInMillis() < shx.getLastChange().getTimeInMillis() ? 1 : 0) != 0);
            ++i2;
        }
    }

    @Test
    public void testObj09() throws Exception {
        SpecObject[] so = this.getObjectsByName("Obj-09");
        int i = 0;
        while (i < so.length) {
            Assert.assertNotNull((Object)so[i]);
            int j = i + 1;
            while (j < so.length) {
                Assert.assertTrue((String)("i=" + i + ", j=" + j), (boolean)EcoreUtil.equals((EObject)so[i], (EObject)so[j]));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            Assert.assertNotNull((Object)this.findInSpec("Spec1", so[i]));
            Assert.assertNull((Object)this.findInSpec("Spec2", so[i]));
            ++i;
        }
        Assert.assertNull((Object)this.findInSpec("Spec1", so[3]));
        Assert.assertNotNull((Object)this.findInSpec("Spec2", so[3]));
    }

    protected static void doSaveReqIFFile(EObject reqif, String fileName) throws IOException {
        URI emfURI = TC18xxHISExchangeProcessTests.createEMFURI(fileName);
        Resource resource = TC18xxHISExchangeProcessTests.getXMLPersistenceMappingResourceSet().createResource(emfURI);
        resource.getContents().add((Object)reqif);
        resource.save(TC18xxHISExchangeProcessTests.getSaveOptions());
    }
}

