/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Map;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ContainerConfig;
import org.mandas.docker.client.messages.mount.Mount;
import org.mandas.docker.client.messages.swarm.ConfigBind;
import org.mandas.docker.client.messages.swarm.DnsConfig;
import org.mandas.docker.client.messages.swarm.ImmutableContainerSpec;
import org.mandas.docker.client.messages.swarm.SecretBind;

@JsonDeserialize(builder=ImmutableContainerSpec.Builder.class)
@Value.Immutable
public interface ContainerSpec {
    @JsonProperty(value="Image")
    public String image();

    @JsonProperty(value="Hostname")
    @Nullable
    public String hostname();

    @JsonProperty(value="Labels")
    public Map<String, String> labels();

    @JsonProperty(value="Command")
    @Nullable
    public List<String> command();

    @JsonProperty(value="Args")
    @Nullable
    public List<String> args();

    @JsonProperty(value="Env")
    @Nullable
    public List<String> env();

    @JsonProperty(value="Dir")
    @Nullable
    public String dir();

    @JsonProperty(value="User")
    @Nullable
    public String user();

    @JsonProperty(value="Groups")
    @Nullable
    public List<String> groups();

    @JsonProperty(value="TTY")
    @Nullable
    public Boolean tty();

    @JsonProperty(value="Mounts")
    @Nullable
    public List<Mount> mounts();

    @JsonProperty(value="StopGracePeriod")
    @Nullable
    public Long stopGracePeriod();

    @JsonProperty(value="Healthcheck")
    @Nullable
    public ContainerConfig.Healthcheck healthcheck();

    @JsonProperty(value="Hosts")
    @Nullable
    public List<String> hosts();

    @JsonProperty(value="Secrets")
    @Nullable
    public List<SecretBind> secrets();

    @JsonProperty(value="Configs")
    @Nullable
    public List<ConfigBind> configs();

    @JsonProperty(value="DNSConfig")
    @Nullable
    public DnsConfig dnsConfig();

    @JsonProperty(value="Sysctls")
    public Map<String, String> sysctls();

    @JsonProperty(value="Init")
    @Nullable
    public Boolean init();

    public static Builder builder() {
        return ImmutableContainerSpec.builder();
    }

    public static interface Builder {
        public Builder image(String var1);

        public Builder addLabel(String var1, String var2);

        public Builder hostname(String var1);

        public Builder labels(Map<String, ? extends String> var1);

        public Builder command(String ... var1);

        public Builder command(Iterable<String> var1);

        public Builder args(String ... var1);

        public Builder args(Iterable<String> var1);

        public Builder env(String ... var1);

        public Builder env(Iterable<String> var1);

        public Builder dir(String var1);

        public Builder user(String var1);

        public Builder groups(String ... var1);

        public Builder groups(Iterable<String> var1);

        public Builder tty(Boolean var1);

        public Builder mounts(Mount ... var1);

        public Builder mounts(Iterable<? extends Mount> var1);

        public Builder stopGracePeriod(Long var1);

        public Builder dnsConfig(DnsConfig var1);

        public Builder healthcheck(ContainerConfig.Healthcheck var1);

        public Builder hosts(Iterable<String> var1);

        public Builder secrets(Iterable<? extends SecretBind> var1);

        public Builder configs(Iterable<? extends ConfigBind> var1);

        public Builder init(Boolean var1);

        public Builder sysctls(Map<String, ? extends String> var1);

        public Builder addSysctl(String var1, String var2);

        public ContainerSpec build();
    }
}

