import { FileSystem, LanguageServicePlugin } from '@volar/language-service';
import { SnapshotDocument } from '@volar/snapshot-document';
import * as vscode from 'vscode-languageserver';
import { URI } from 'vscode-uri';
import type { LanguageServerProject, VolarInitializeResult } from './types.js';
export * from '@volar/snapshot-document';
export declare function createServerBase(connection: vscode.Connection, fs: FileSystem): {
    connection: vscode.Connection;
    fs: FileSystem;
    initializeParams: vscode.InitializeParams;
    initializeResult: VolarInitializeResult;
    languageServicePlugins: LanguageServicePlugin[];
    project: LanguageServerProject;
    pullModelDiagnostics: boolean;
    documents: vscode.TextDocuments<SnapshotDocument>;
    workspaceFolders: Map<URI, boolean>;
    getSyncedDocumentKey: (uri: URI) => string | undefined;
    initialize: (initializeParams: vscode.InitializeParams, project: LanguageServerProject, languageServicePlugins: LanguageServicePlugin[], options?: {
        pullModelDiagnostics?: boolean;
    }) => VolarInitializeResult;
    initialized: () => void;
    shutdown: () => void;
    watchFiles: (patterns: string[]) => void;
    getConfiguration: <T>(section: string, scopeUri?: string) => Promise<T | undefined>;
    onDidChangeConfiguration: (cb: vscode.NotificationHandler<vscode.DidChangeConfigurationParams>) => {
        dispose(): void;
    };
    onDidChangeWatchedFiles: (cb: vscode.NotificationHandler<vscode.DidChangeWatchedFilesParams>) => {
        dispose: () => void;
    };
    clearPushDiagnostics: () => void;
    refresh: (project: LanguageServerProject) => Promise<void>;
};
