/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.BaseTypeSafeConstraint;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;

public class ExpressionEvaluation
extends BaseTypeSafeConstraint {
    private IExpressionEvaluator evaluator;
    private boolean isUnwinding;

    public ExpressionEvaluation(PBody pBody, IExpressionEvaluator evaluator, PVariable outputVariable) {
        this(pBody, evaluator, outputVariable, false);
    }

    public ExpressionEvaluation(PBody pBody, IExpressionEvaluator evaluator, PVariable outputVariable, boolean isUnwinding) {
        super(pBody, ExpressionEvaluation.getPVariablesOfExpression(pBody, evaluator), outputVariable);
        this.evaluator = evaluator;
        this.isUnwinding = isUnwinding;
    }

    public boolean isUnwinding() {
        return this.isUnwinding;
    }

    public IExpressionEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    protected String toStringRest() {
        return Tuples.flatTupleOf(new ArrayList(this.inputVariables).toArray()).toString() + "|=" + this.evaluator.getShortDescription();
    }

    @Override
    public Map<Set<PVariable>, Set<PVariable>> getFunctionalDependencies(IQueryMetaContext context) {
        if (this.outputVariable == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(this.inputVariables, Collections.singleton(this.outputVariable));
    }

    private static Set<PVariable> getPVariablesOfExpression(PBody pBody, IExpressionEvaluator evaluator) {
        LinkedHashSet<PVariable> result = new LinkedHashSet<PVariable>();
        for (String name : evaluator.getInputParameterNames()) {
            PVariable variable = pBody.getOrCreateVariableByName(name);
            result.add(variable);
        }
        return result;
    }
}

