/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.ide.internal.provider;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tips.core.IHtmlTip;
import org.eclipse.tips.core.Tip;
import org.eclipse.tips.core.TipAction;
import org.eclipse.tips.core.TipImage;
import org.eclipse.tips.ide.internal.Messages;
import org.eclipse.tips.ide.internal.provider.TipHtml;
import org.eclipse.tips.ide.internal.provider.TipsTipProvider;

public class Tip7_Extend
extends Tip
implements IHtmlTip {
    private TipImage fImage;

    public Tip7_Extend(String providerId) {
        super(providerId);
    }

    public List<TipAction> getActions() {
        Runnable action = () -> Display.getDefault().asyncExec(() -> {
            boolean confirm;
            if (Platform.isRunning() && Platform.getWS().startsWith("gtk") && !(confirm = MessageDialog.openConfirm(null, (String)Messages.Tip7_Extend_gtk_browser_failure_title, (String)Messages.Tip7_Extend_gtk_browser_failure_message))) {
                return;
            }
            try {
                Desktop.getDesktop().browse(new URI("https://wiki.eclipse.org/Tip_of_the_Day"));
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace();
            }
        });
        return List.of(new TipAction(Messages.Tip7_Extend_action_title, Messages.Tip7_Extend_action_description, action, null));
    }

    public Date getCreationDate() {
        return TipsTipProvider.getDateFromYYMMDD(9, 1, 2019);
    }

    public String getSubject() {
        return Messages.Tip7_Extend_subject;
    }

    public String getHTML() {
        return new TipHtml(Messages.Tip7_Extend_text_header, Messages.Tip7_Extend_text_body).get();
    }

    public TipImage getImage() {
        if (this.fImage == null) {
            Optional<TipImage> tipImage = TipsTipProvider.getTipImage("images/tips/photon.jpg");
            this.fImage = tipImage.map(i -> i.setAspectRatio(720, 480, true)).orElse(null);
        }
        return this.fImage;
    }
}

