/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.shells.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeListener;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.internal.shells.ui.ShellResources;
import org.eclipse.rse.shells.ui.RemoteCommandHelpers;
import org.eclipse.rse.subsystems.files.core.model.ISystemRemoteCommand;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.model.ISystemShellProvider;
import org.eclipse.rse.ui.widgets.SystemHostCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class SystemRemoteCommandEntryForm
extends Composite
implements ISystemResourceChangeListener,
ISystemShellProvider {
    private SystemHostCombo sysConnCombo;
    private IRemoteCmdSubSystem[] subSystems = null;
    private int subSystemIndex = -1;
    private Combo cmdCombo;
    private Combo subSysCombo;
    private Button runButton;

    public SystemRemoteCommandEntryForm(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        this.setLayoutData(gridData);
        this.sysConnCombo = new SystemHostCombo((Composite)this, 0, null, false, "commands", false);
        this.sysConnCombo.setWidthHint(100);
        this.sysConnCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SystemRemoteCommandEntryForm.this.sysConnChanged();
            }
        });
        this.sysConnCombo.listenToConnectionEvents(true);
        this.subSysCombo = SystemWidgetHelpers.createReadonlyCombo((Composite)this, (Listener)new Listener(){

            public void handleEvent(Event e) {
                SystemRemoteCommandEntryForm.this.subSysChanged();
            }
        }, (String)ShellResources.RESID_COMMANDSVIEW_SUBSYSCOMBO_TOOLTIP);
        ((GridData)this.subSysCombo.getLayoutData()).widthHint = 100;
        this.cmdCombo = SystemWidgetHelpers.createCombo((Composite)this, (Listener)new Listener(){

            public void handleEvent(Event e) {
                SystemRemoteCommandEntryForm.this.commandChanged();
            }
        }, (String)ShellResources.RESID_COMMANDSVIEW_CMDCOMBO_TOOLTIP);
        this.cmdCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemRemoteCommandEntryForm.this.checkRunButtonEnablement();
            }
        });
        ((GridData)this.cmdCombo.getLayoutData()).widthHint = 250;
        this.cmdCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SystemRemoteCommandEntryForm.this.handleCmdComboEnter();
            }
        });
        this.runButton = SystemWidgetHelpers.createPushButton((Composite)this, (Listener)new Listener(){

            public void handleEvent(Event e) {
                SystemRemoteCommandEntryForm.this.runCommand();
            }
        }, (String)ShellResources.RESID_COMMANDSVIEW_RUN_LABEL, (String)ShellResources.RESID_COMMANDSVIEW_RUN_TOOLTIP);
        this.pack();
        this.populateSubSysCombo();
        this.populateCommandCombo();
        this.checkRunButtonEnablement();
        this.cmdCombo.setFocus();
        RSECorePlugin.getTheSystemRegistry().addSystemResourceChangeListener((ISystemResourceChangeListener)this);
    }

    private void runCommand() {
        IHost sysConn;
        String cmd = this.cmdCombo.getText();
        if (cmd.length() > 0 && (sysConn = this.sysConnCombo.getHost()) != null) {
            IRemoteCmdSubSystem[] cmdSubSystems = RemoteCommandHelpers.getCmdSubSystems(sysConn);
            IRemoteCmdSubSystem currSubSystem = null;
            String subSystemName = this.subSysCombo.getText();
            int i = 0;
            while (i < cmdSubSystems.length && currSubSystem == null) {
                if (subSystemName.equals(cmdSubSystems[i].getName())) {
                    currSubSystem = cmdSubSystems[i];
                }
                ++i;
            }
            if (currSubSystem != null) {
                try {
                    currSubSystem.runCommand(cmd, null, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    SystemBasePlugin.logInfo((String)("Exception invoking command " + cmd + " on " + sysConn.getAliasName()));
                }
            }
        }
    }

    private void commandChanged() {
        this.checkRunButtonEnablement();
    }

    private void subSysChanged() {
        this.subSystemIndex = this.subSysCombo.getSelectionIndex();
        this.populateCommandCombo();
        this.checkRunButtonEnablement();
    }

    private void sysConnChanged() {
        this.populateSubSysCombo();
        this.populateCommandCombo();
        this.checkRunButtonEnablement();
    }

    private void checkRunButtonEnablement() {
        if (this.sysConnCombo.getText().length() > 0 && this.subSysCombo.getText().length() > 0 && this.cmdCombo.getText().trim().length() > 0) {
            this.runButton.setEnabled(true);
        } else {
            this.runButton.setEnabled(false);
        }
    }

    private void populateSubSysCombo() {
        this.subSysCombo.removeAll();
        IHost sysConn = this.sysConnCombo.getHost();
        if (sysConn != null) {
            this.subSystems = RemoteCommandHelpers.getCmdSubSystems(sysConn);
            int i = 0;
            while (i < this.subSystems.length) {
                if (i == 0) {
                    this.subSystemIndex = 0;
                }
                this.subSysCombo.add(this.subSystems[i].getName());
                ++i;
            }
            this.subSysCombo.select(0);
        }
    }

    private void populateCommandCombo() {
        String[] cmds;
        this.cmdCombo.removeAll();
        if (this.subSystemIndex >= 0 && (cmds = this.subSystems[this.subSystemIndex].getExecutedCommands()) != null) {
            this.cmdCombo.setItems(cmds);
        }
    }

    public void systemResourceChanged(ISystemResourceChangeEvent event) {
        int type = event.getType();
        Object src = event.getSource();
        switch (type) {
            case 110: {
                if (!(src instanceof ISystemRemoteCommand) || this.subSystemIndex < 0 || this.subSystems[this.subSystemIndex] != ((ISystemRemoteCommand)src).getSubSystem()) break;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        SystemRemoteCommandEntryForm.this.populateCommandCombo();
                    }
                });
                break;
            }
            case 115: {
                break;
            }
            case 130: {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        SystemRemoteCommandEntryForm.this.populateCommandCombo();
                    }
                });
            }
        }
    }

    private void handleCmdComboEnter() {
        if (this.runButton.isEnabled()) {
            this.runCommand();
        }
    }
}

