/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.completeocl.utilities;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.External2AS;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotObjectImpl;
import org.eclipse.ocl.pivot.internal.validation.PivotEObjectValidator;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.validation.ValidationRegistryAdapter;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.completeocl.CompleteOCLStandaloneSetup;

public abstract class CompleteOCLLoader {
    protected final @NonNull OCLInternal ocl;
    protected final @NonNull List<@NonNull Model> oclModels = new ArrayList<Model>();
    protected final @NonNull Set<@NonNull EPackage> mmPackages;

    public CompleteOCLLoader(@NonNull EnvironmentFactory environmentFactory) {
        this.ocl = OCLInternal.newInstance((EnvironmentFactoryInternal)((EnvironmentFactoryInternal)environmentFactory));
        this.mmPackages = new HashSet<EPackage>();
    }

    public void dispose() {
        this.ocl.dispose();
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.ocl.getEnvironmentFactory();
    }

    public @NonNull MetamodelManager getMetamodelManager() {
        return this.ocl.getMetamodelManager();
    }

    public boolean loadMetamodels() {
        for (Resource resource : this.ocl.getResourceSet().getResources()) {
            assert (resource != null);
            External2AS ecore2as = Ecore2AS.findAdapter((Resource)resource, (EnvironmentFactoryInternal)this.ocl.getEnvironmentFactory());
            if (ecore2as != null) continue;
            TreeIterator tit = resource.getAllContents();
            while (tit.hasNext()) {
                EPackage mmPackage;
                EObject eObject = (EObject)tit.next();
                EClass eClass = eObject.eClass();
                if (eClass == null || (mmPackage = eClass.getEPackage()) == null) continue;
                this.mmPackages.add(mmPackage);
            }
        }
        HashSet<Resource> mmResources = new HashSet<Resource>();
        for (EPackage mmPackage : this.mmPackages) {
            Resource mmResource = EcoreUtil.getRootContainer((EObject)mmPackage).eResource();
            if (mmResource == null) continue;
            mmResources.add(mmResource);
        }
        for (Resource mmResource : mmResources) {
            assert (mmResource != null);
            try {
                Element pivotModel = this.ocl.getEnvironmentFactory().loadResource(mmResource, null);
                if (pivotModel != null) {
                    EList errors = pivotModel.eResource().getErrors();
                    assert (errors != null);
                    String message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
                    if (message == null) continue;
                    return this.error("Failed to load Pivot from '" + mmResource.getURI(), message);
                }
                return this.error("Failed to load Pivot from '" + mmResource.getURI(), "");
            }
            catch (ParserException e) {
                return this.error("Failed to load Pivot from '" + mmResource.getURI(), e.getMessage());
            }
        }
        return true;
    }

    protected abstract boolean error(@NonNull String var1, @Nullable String var2);

    public void installPackages() {
        ResourceSet resourceSet = this.ocl.getEnvironmentFactory().getResourceSet();
        ValidationRegistryAdapter localValidationRegistry = ValidationRegistryAdapter.getAdapter((ResourceSet)resourceSet);
        PivotEObjectValidator extraEValidator = new PivotEObjectValidator(this.oclModels);
        for (EPackage mmPackage : this.mmPackages) {
            localValidationRegistry.add(mmPackage, (EValidator)extraEValidator);
        }
    }

    public boolean loadDocument(@NonNull URI oclURI) {
        return this.loadDocument(oclURI, null);
    }

    public boolean loadDocument(@NonNull URI oclURI, @Nullable StringBuilder sErrors) {
        Resource resource = this.loadResource(oclURI, sErrors);
        if (resource == null) {
            return false;
        }
        MetamodelManagerInternal metamodelManager = this.ocl.getMetamodelManager();
        TreeIterator tit = resource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (eObject instanceof Package) {
                EObject mmPackage;
                Package aPackage = metamodelManager.getPrimaryPackage((Package)eObject);
                if (!(aPackage instanceof PivotObjectImpl) || !((mmPackage = ((PivotObjectImpl)aPackage).getESObject()) instanceof EPackage)) continue;
                this.mmPackages.add((EPackage)mmPackage);
                continue;
            }
            if (eObject instanceof Type) {
                tit.prune();
                continue;
            }
            if (!(eObject instanceof Model)) continue;
            this.oclModels.add((Model)eObject);
        }
        return true;
    }

    public Resource loadResource(@NonNull URI oclURI) {
        return this.loadResource(oclURI, null);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Resource loadResource(@NonNull URI oclURI, @Nullable StringBuilder sErrors) {
        CompleteOCLStandaloneSetup.init();
        ResourceSet resourceSet = this.ocl.getResourceSet();
        Resource resource = null;
        URI loadURI = oclURI;
        String message2 = null;
        try {
            resource = resourceSet.getResource(loadURI, true);
        }
        catch (WrappedException e) {
            IStatus status;
            URI retryURI = null;
            Throwable cause = e.getCause();
            if (cause instanceof CoreException && (status = ((CoreException)cause).getStatus()).getCode() == 368 && status.getPlugin().equals("org.eclipse.core.resources") && oclURI.isPlatformResource()) {
                retryURI = URI.createPlatformPluginURI((String)oclURI.toPlatformString(false), (boolean)false);
            }
            if (retryURI != null) {
                loadURI = retryURI;
                resource = resourceSet.getResource(retryURI, true);
            }
            throw e;
        }
        BaseCSResource xtextResource = null;
        if (resource instanceof BaseCSResource) {
            xtextResource = (BaseCSResource)resource;
        } else {
            message2 = "An " + resource.getClass().getName() + " loaded rather than the required BaseCSResource.";
        }
        if (xtextResource != null && message2 == null) {
            @NonNull EList errors = xtextResource.getErrors();
            assert (errors != null);
            message2 = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
            if (message2 == null) {
                ASResource asResource = xtextResource.getASResource();
                errors = asResource.getErrors();
                assert (errors != null);
                message2 = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
                if (message2 == null) {
                    return asResource;
                }
            }
        }
        assert (message2 != null);
        String message1 = "Failed to load '" + loadURI + "' as an OCL document.";
        if (sErrors != null) {
            sErrors.append(message1);
            sErrors.append("\n");
            sErrors.append(message2);
        } else {
            this.error(message1, message2);
        }
        return null;
    }

    public static final class CompleteOCLLoaderWithLog
    extends CompleteOCLLoader {
        StringBuilder s = new StringBuilder();

        public CompleteOCLLoaderWithLog(@NonNull EnvironmentFactory environmentFactory) {
            super(environmentFactory);
        }

        @Override
        protected boolean error(@NonNull String primaryMessage, @Nullable String detailMessage) {
            this.s.append(primaryMessage);
            this.s.append(detailMessage);
            return false;
        }

        public String toString() {
            return this.s.toString();
        }
    }
}

