/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.core;

import java.io.IOException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.IVMVirtualMachineShell;
import org.eclipse.ocl.examples.debug.vm.request.VMTerminateRequest;

public abstract class VMVirtualProcess
extends PlatformObject
implements IProcess {
    protected final @NonNull ILaunch fLaunch;
    private final @NonNull IVMVirtualMachineShell fVM;
    private IStreamsProxy fStreamsPxy;

    public VMVirtualProcess(@NonNull ILaunch launch, @NonNull IVMVirtualMachineShell vm) {
        this.fLaunch = launch;
        this.fVM = vm;
        this.fLaunch.addProcess((IProcess)this);
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public String getAttribute(String key) {
        return null;
    }

    public int getExitValue() throws DebugException {
        return 0;
    }

    public IStreamsProxy getStreamsProxy() {
        return this.fStreamsPxy;
    }

    public abstract @NonNull String getLabel();

    public @NonNull ILaunch getLaunch() {
        return this.fLaunch;
    }

    public boolean isTerminated() {
        return this.fVM.isTerminated();
    }

    public void setAttribute(String key, String value) {
    }

    public void setStreamsProxy(@NonNull IStreamsProxy streamsProxy) {
        this.fStreamsPxy = streamsProxy;
    }

    public void terminate() throws DebugException {
        try {
            this.fVM.sendRequest(new VMTerminateRequest());
        }
        catch (IOException e) {
            throw new DebugException(this.fVM.getDebugCore().createDebugError("Process termination Failed", e));
        }
    }

    protected void terminated() {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            DebugEvent event = new DebugEvent((Object)this, 8);
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }
}

