/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskSelectionDialog;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;

public class OpenTaskAction
extends ActionDelegate
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        TaskSelectionDialog dlg = new TaskSelectionDialog(this.window.getShell(), true);
        dlg.setTitle(Messages.OpenTaskAction_Open_Task);
        dlg.setMessage(Messages.OpenTaskAction_Select_a_task_to_open__);
        dlg.setShowExtendedOpeningOptions(true);
        dlg.setHelpAvailable(false);
        if (dlg.open() != 0) {
            return;
        }
        if (dlg.getResult() != null) {
            Object[] objectArray = dlg.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                if (result instanceof ITask) {
                    AbstractTask task = (AbstractTask)result;
                    if (dlg.getOpenInBrowser()) {
                        TasksUiUtil.openWithBrowser((IRepositoryElement)task);
                    } else {
                        TasksUiInternal.refreshAndOpenTaskListElement((IRepositoryElement)task);
                    }
                }
                ++n2;
            }
        }
    }
}

