/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.util.atl.core.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.drivers.emf4atl.EMFModelLoader;
import org.eclipse.m2m.atl.engine.vm.AtlLauncher;
import org.eclipse.m2m.atl.engine.vm.AtlModelHandler;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public class AtlLaunchHelper {
    private EMFModelLoader modelLoader;

    private void createResources() {
        this.modelLoader = (EMFModelLoader)AtlModelHandler.getDefault((String)"EMF").createModelLoader();
    }

    private void initMetamodels(Map<String, ASMModel> models, List<ModelInfo> inputModels, List<ModelInfo> outputModels) throws IOException {
        ASMEMFModel metamodel;
        for (ModelInfo modelInfo : inputModels) {
            if (models.containsKey(modelInfo.getMetamodelName())) continue;
            metamodel = this.modelLoader.loadModel(modelInfo.getMetamodelName(), this.modelLoader.getMOF(), modelInfo.getMetamodelUri());
            models.put(modelInfo.getMetamodelName(), (ASMModel)metamodel);
        }
        for (ModelInfo modelInfo : outputModels) {
            if (models.containsKey(modelInfo.getMetamodelName())) continue;
            metamodel = this.modelLoader.loadModel(modelInfo.getMetamodelName(), this.modelLoader.getMOF(), modelInfo.getMetamodelUri());
            models.put(modelInfo.getMetamodelName(), (ASMModel)metamodel);
        }
    }

    private void initModels(Map<String, ASMModel> models, List<ModelInfo> inputModels, List<ModelInfo> outputModels) throws IOException {
        for (ModelInfo modelInfo : inputModels) {
            ASMEMFModel inputModel;
            Resource resource = modelInfo.getResource();
            if (resource != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                resource.save((OutputStream)byteArrayOutputStream, null);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                inputModel = this.modelLoader.loadModel(modelInfo.getModelName(), models.get(modelInfo.getMetamodelName()), (InputStream)inputStream);
            } else {
                inputModel = this.modelLoader.loadModel(modelInfo.getModelName(), models.get(modelInfo.getMetamodelName()), modelInfo.getModelURI());
            }
            models.put(modelInfo.getModelName(), (ASMModel)inputModel);
        }
        for (ModelInfo modelInfo : outputModels) {
            ASMEMFModel outputModel = (ASMEMFModel)this.modelLoader.newModel(modelInfo.getModelName(), URI.decode((String)modelInfo.getModelURI().toString()), models.get(modelInfo.getMetamodelName()));
            models.put(modelInfo.getModelName(), (ASMModel)outputModel);
        }
    }

    public List<Resource> runTransformation(URL transformation, List<ModelInfo> inputModels, List<ModelInfo> outputModels) throws IOException {
        return this.runTransformation(transformation, inputModels, outputModels, new ArrayList<URL>());
    }

    public List<Resource> runTransformation(URL transformation, List<ModelInfo> inputModels, List<ModelInfo> outputModels, List<URL> superimposedTransformations) throws IOException {
        ArrayList<Resource> result = new ArrayList<Resource>();
        HashMap<String, ASMModel> models = new HashMap<String, ASMModel>();
        this.createResources();
        this.initMetamodels(models, inputModels, outputModels);
        this.initModels(models, inputModels, outputModels);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("continueAfterError", "true");
        options.put("printExecutionTime", "true");
        AtlLauncher.getDefault().launch(transformation, Collections.EMPTY_MAP, models, Collections.EMPTY_MAP, superimposedTransformations, options);
        for (ModelInfo omi : outputModels) {
            ASMModel outputModel = (ASMModel)models.get(omi.getModelName());
            if (outputModel instanceof ASMEMFModel) {
                ASMEMFModel asmEmfModel = (ASMEMFModel)outputModel;
                Resource resource = asmEmfModel.getExtent();
                result.add(AtlLaunchHelper.moveToNewXMIResource(resource));
                continue;
            }
            throw new RuntimeException("Model type not handled: " + outputModel.getClass().getName());
        }
        return result;
    }

    public Resource runTransformation(URL transformation, ModelInfo inputModel, ModelInfo outputModel) throws IOException {
        ArrayList<ModelInfo> inputModels = new ArrayList<ModelInfo>();
        inputModels.add(inputModel);
        ArrayList<ModelInfo> outputModels = new ArrayList<ModelInfo>();
        outputModels.add(outputModel);
        List<Resource> results = this.runTransformation(transformation, inputModels, outputModels);
        if (results.size() > 0) {
            Resource resultResource = results.get(0);
            Resource newXMIResource = AtlLaunchHelper.moveToNewXMIResource(resultResource);
            newXMIResource.setURI(outputModel.getModelURI());
            return newXMIResource;
        }
        return null;
    }

    private static Resource moveToNewXMIResource(Resource resource) {
        XMIResourceImpl xmiResourceImpl = new XMIResourceImpl();
        ListIterator listIterator = resource.getContents().listIterator();
        while (listIterator.hasNext()) {
            EObject eObject = (EObject)listIterator.next();
            listIterator.remove();
            xmiResourceImpl.getContents().add((Object)eObject);
        }
        return xmiResourceImpl;
    }

    public static class ModelInfo {
        private final String modelName;
        private final URI modelURI;
        private final Resource resource;
        private final String metamodelName;
        private final URI metamodelUri;

        public ModelInfo(String name, URI modelURI, Resource resource, String metamodelName, URI metamodelUri) {
            this.modelName = name;
            this.modelURI = modelURI;
            this.resource = resource;
            this.metamodelName = metamodelName;
            this.metamodelUri = metamodelUri;
        }

        public String getModelName() {
            return this.modelName;
        }

        public URI getModelURI() {
            return this.modelURI;
        }

        public Resource getResource() {
            return this.resource;
        }

        public String getMetamodelName() {
            return this.metamodelName;
        }

        public URI getMetamodelUri() {
            return this.metamodelUri;
        }
    }
}

